/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.yql.configuration;

import org.apache.camel.component.yql.configuration.YqlConfiguration;
import org.apache.camel.component.yql.exception.YqlException;
import org.apache.commons.lang3.StringUtils;

public final class YqlConfigurationValidator {
    private YqlConfigurationValidator() {
    }

    public static void validateProperties(YqlConfiguration configuration) {
        if (StringUtils.isEmpty((CharSequence)configuration.getQuery())) {
            throw new YqlException("<query> is not present or not valid!");
        }
        if (!StringUtils.equalsAny((CharSequence)configuration.getFormat(), (CharSequence[])new CharSequence[]{"json", "xml"})) {
            throw new YqlException("<format> is not valid!");
        }
        if (configuration.getCrossProduct() != null && !configuration.getCrossProduct().equals("optimized")) {
            throw new YqlException("<crossProduct> is not valid!");
        }
        if (configuration.getJsonCompat() != null && !configuration.getJsonCompat().equals("new")) {
            throw new YqlException("<jsonCompat> is not valid!");
        }
    }
}

