/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.yql.client;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.component.yql.client.YqlResponse;
import org.apache.camel.component.yql.configuration.YqlConfiguration;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YqlClient {
    private static final Logger LOG = LoggerFactory.getLogger(YqlClient.class);
    private final CloseableHttpClient httpClient;

    public YqlClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public YqlResponse get(YqlConfiguration yqlConfiguration) throws Exception {
        URI uri = new URIBuilder().setScheme(yqlConfiguration.isHttps() ? "https" : "http").setHost("query.yahooapis.com").setPath("/v1/public/yql").setParameters(this.buildParameters(yqlConfiguration)).build();
        LOG.debug("YQL query: {}", (Object)uri);
        HttpGet httpget = new HttpGet(uri);
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpget);){
            YqlResponse yqlResponse = YqlResponse.builder().httpRequest(uri.toString()).status(response.getStatusLine().getStatusCode()).body(EntityUtils.toString((HttpEntity)response.getEntity())).build();
            LOG.debug("YQL response: {}", (Object)yqlResponse.getBody());
            YqlResponse yqlResponse2 = yqlResponse;
            return yqlResponse2;
        }
    }

    private List<NameValuePair> buildParameters(YqlConfiguration yqlConfiguration) {
        ArrayList<NameValuePair> nameValuePairs = new ArrayList<NameValuePair>();
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("q", yqlConfiguration.getQuery()));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("format", yqlConfiguration.getFormat()));
        String callback = yqlConfiguration.getCallback();
        if (callback == null) {
            callback = "";
        }
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("callback", callback));
        if (yqlConfiguration.getCrossProduct() != null) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("crossProduct", yqlConfiguration.getCrossProduct()));
        }
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("diagnostics", Boolean.toString(yqlConfiguration.isDiagnostics())));
        nameValuePairs.add((NameValuePair)new BasicNameValuePair("debug", Boolean.toString(yqlConfiguration.isDebug())));
        if (yqlConfiguration.getEnv() != null) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("env", yqlConfiguration.getEnv()));
        }
        if (yqlConfiguration.getJsonCompat() != null) {
            nameValuePairs.add((NameValuePair)new BasicNameValuePair("jsonCompat", yqlConfiguration.getJsonCompat()));
        }
        return nameValuePairs;
    }
}

