/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pubnub;

import com.pubnub.api.PubNub;
import com.pubnub.api.callbacks.SubscribeCallback;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.consumer.pubsub.PNMessageResult;
import com.pubnub.api.models.consumer.pubsub.PNPresenceEventResult;
import java.util.Arrays;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.pubnub.PubNubConfiguration;
import org.apache.camel.component.pubnub.PubNubEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubNubConsumer
extends DefaultConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(PubNubConsumer.class);
    private final PubNubEndpoint endpoint;
    private final PubNubConfiguration pubNubConfiguration;

    public PubNubConsumer(PubNubEndpoint endpoint, Processor processor, PubNubConfiguration pubNubConfiguration) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.pubNubConfiguration = pubNubConfiguration;
    }

    private void initCommunication() throws Exception {
        this.endpoint.getPubnub().addListener((SubscribeCallback)new PubNubCallback());
        if (this.pubNubConfiguration.withPresence()) {
            this.endpoint.getPubnub().subscribe().channels(Arrays.asList(this.pubNubConfiguration.getChannel())).withPresence().execute();
        } else {
            this.endpoint.getPubnub().subscribe().channels(Arrays.asList(this.pubNubConfiguration.getChannel())).execute();
        }
    }

    private void terminateCommunication() {
        try {
            this.endpoint.getPubnub().unsubscribe().channels(Arrays.asList(this.pubNubConfiguration.getChannel())).execute();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.initCommunication();
    }

    protected void doResume() throws Exception {
        super.doResume();
        this.initCommunication();
    }

    protected void doStop() throws Exception {
        this.terminateCommunication();
        super.doStop();
    }

    protected void doSuspend() throws Exception {
        this.terminateCommunication();
        super.doSuspend();
    }

    class PubNubCallback
    extends SubscribeCallback {
        PubNubCallback() {
        }

        public void status(PubNub pubnub, PNStatus status) {
            if (status.getCategory() == PNStatusCategory.PNUnexpectedDisconnectCategory || status.getCategory() == PNStatusCategory.PNTimeoutCategory) {
                LOG.trace("Got status: {}. Reconnecting to PubNub", (Object)status);
                pubnub.reconnect();
            } else {
                LOG.trace("Status message: {}", (Object)status);
            }
        }

        public void message(PubNub pubnub, PNMessageResult message) {
            Exchange exchange = PubNubConsumer.this.endpoint.createExchange();
            Message inmessage = exchange.getIn();
            inmessage.setBody((Object)message);
            inmessage.setHeader("CamelPubNubTimeToken", (Object)message.getTimetoken());
            inmessage.setHeader("CamelPubNubChannel", (Object)message.getChannel());
            try {
                PubNubConsumer.this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                PubNubConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)e);
            }
        }

        public void presence(PubNub pubnub, PNPresenceEventResult presence) {
            Exchange exchange = PubNubConsumer.this.endpoint.createExchange();
            Message inmessage = exchange.getIn();
            inmessage.setBody((Object)presence);
            inmessage.setHeader("CamelPubNubTimeToken", (Object)presence.getTimetoken());
            inmessage.setHeader("CamelPubNubChannel", (Object)presence.getChannel());
            try {
                PubNubConsumer.this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                exchange.setException((Throwable)e);
                PubNubConsumer.this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)e);
            }
        }
    }
}

