/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.cache;

import java.io.Serializable;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.Service;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.component.cache.DefaultCacheManagerFactory;
import org.apache.camel.processor.cache.CacheValidate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheBasedMessageBodyReplacer
extends CacheValidate
implements Processor,
Service {
    private static final Logger LOG = LoggerFactory.getLogger(CacheBasedMessageBodyReplacer.class);
    private CacheManager cacheManager;
    private String cacheName;
    private Expression key;

    public CacheBasedMessageBodyReplacer(String cacheName, String key) {
        this(cacheName, ExpressionBuilder.constantExpression((Object)key));
    }

    public CacheBasedMessageBodyReplacer(String cacheName, Expression key) {
        if (cacheName.contains("cache://")) {
            this.setCacheName(cacheName.replace("cache://", ""));
        } else {
            this.setCacheName(cacheName);
        }
        this.setKey(key);
    }

    public void process(Exchange exchange) throws Exception {
        String cacheKey = (String)this.key.evaluate(exchange, String.class);
        if (this.isValid(this.cacheManager, this.cacheName, cacheKey)) {
            Cache cache = this.cacheManager.getCache(this.cacheName);
            LOG.debug("Replacing Message Body from CacheName {} for key {}", (Object)this.cacheName, (Object)cacheKey);
            exchange.getIn().setHeader("CamelCacheKey", (Object)cacheKey);
            exchange.getIn().setBody(cache.get((Serializable)((Object)cacheKey)).getObjectValue());
        }
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public void setCacheName(String cacheName) {
        this.cacheName = cacheName;
    }

    public Expression getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = ExpressionBuilder.constantExpression((Object)key);
    }

    public void setKey(Expression key) {
        this.key = key;
    }

    public void start() throws Exception {
        if (this.cacheManager == null) {
            this.cacheManager = new DefaultCacheManagerFactory().getInstance();
        }
    }

    public void stop() throws Exception {
    }
}

