/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.queue;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.azure.queue.QueueServiceConfiguration;
import org.apache.camel.component.azure.queue.QueueServiceConsumer;
import org.apache.camel.component.azure.queue.QueueServiceProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.19.0", scheme="azure-queue", title="Azure Storage Queue Service", syntax="azure-blob:containerAndQueueUri", consumerClass=QueueServiceConsumer.class, label="cloud,queue,azure")
public class QueueServiceEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(QueueServiceEndpoint.class);
    @UriPath(description="Container Queue compact Uri")
    @Metadata(required="true")
    private String containerAndQueueUri;
    @UriParam
    private QueueServiceConfiguration configuration;

    public QueueServiceEndpoint(String uri, Component comp, QueueServiceConfiguration configuration) {
        super(uri, comp);
        this.configuration = configuration;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        LOG.trace("Creating a consumer");
        QueueServiceConsumer consumer = new QueueServiceConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Producer createProducer() throws Exception {
        LOG.trace("Creating a producer");
        return new QueueServiceProducer((Endpoint)this);
    }

    public boolean isSingleton() {
        return true;
    }

    public QueueServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(QueueServiceConfiguration configuration) {
        this.configuration = configuration;
    }
}

