/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.blob;

import com.microsoft.azure.storage.AccessCondition;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.StorageCredentials;
import com.microsoft.azure.storage.blob.BlobInputStream;
import com.microsoft.azure.storage.blob.BlobRequestOptions;
import com.microsoft.azure.storage.blob.CloudAppendBlob;
import com.microsoft.azure.storage.blob.CloudBlob;
import com.microsoft.azure.storage.blob.CloudBlobContainer;
import com.microsoft.azure.storage.blob.CloudBlockBlob;
import com.microsoft.azure.storage.blob.CloudPageBlob;
import com.microsoft.azure.storage.blob.PageRange;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.camel.Exchange;
import org.apache.camel.component.azure.blob.BlobServiceConfiguration;
import org.apache.camel.component.azure.blob.BlobServiceRequestOptions;
import org.apache.camel.component.azure.blob.BlobType;
import org.apache.camel.component.azure.common.ExchangeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BlobServiceUtil {
    private static final Logger LOG = LoggerFactory.getLogger(BlobServiceUtil.class);

    private BlobServiceUtil() {
    }

    public static void getBlob(Exchange exchange, BlobServiceConfiguration cfg) throws Exception {
        switch (cfg.getBlobType()) {
            case blockblob: {
                BlobServiceUtil.getBlockBlob(exchange, cfg);
                break;
            }
            case appendblob: {
                BlobServiceUtil.getAppendBlob(exchange, cfg);
                break;
            }
            case pageblob: {
                BlobServiceUtil.getPageBlob(exchange, cfg);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported blob type");
            }
        }
    }

    private static void getBlockBlob(Exchange exchange, BlobServiceConfiguration cfg) throws Exception {
        CloudBlockBlob client = BlobServiceUtil.createBlockBlobClient(cfg);
        BlobServiceUtil.doGetBlob((CloudBlob)client, exchange, cfg);
    }

    private static void getAppendBlob(Exchange exchange, BlobServiceConfiguration cfg) throws Exception {
        CloudAppendBlob client = BlobServiceUtil.createAppendBlobClient(cfg);
        BlobServiceUtil.doGetBlob((CloudBlob)client, exchange, cfg);
    }

    private static void getPageBlob(Exchange exchange, BlobServiceConfiguration cfg) throws Exception {
        CloudPageBlob client = BlobServiceUtil.createPageBlobClient(cfg);
        BlobServiceUtil.doGetBlob((CloudBlob)client, exchange, cfg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doGetBlob(CloudBlob client, Exchange exchange, BlobServiceConfiguration cfg) throws Exception {
        String fileDir;
        BlobServiceUtil.configureCloudBlobForRead(client, cfg);
        BlobServiceRequestOptions opts = BlobServiceUtil.getRequestOptions(exchange);
        LOG.trace("Getting a blob [{}] from exchange [{}]...", (Object)cfg.getBlobName(), (Object)exchange);
        OutputStream os = (OutputStream)exchange.getIn().getBody(OutputStream.class);
        if (os == null && (fileDir = cfg.getFileDir()) != null) {
            File file = new File(fileDir, BlobServiceUtil.getBlobFileName(cfg));
            ExchangeUtil.getMessageForResponse(exchange).setBody((Object)file);
            os = new FileOutputStream(file);
        }
        try {
            if (os == null) {
                BlobInputStream blobStream = client.openInputStream(opts.getAccessCond(), opts.getRequestOpts(), opts.getOpContext());
                exchange.getIn().setBody((Object)blobStream);
                exchange.getIn().setHeader("CamelFileName", (Object)BlobServiceUtil.getBlobFileName(cfg));
            } else {
                PageRange range;
                Long blobOffset = cfg.getBlobOffset();
                Long blobDataLength = cfg.getDataLength();
                if (client instanceof CloudPageBlob && (range = (PageRange)exchange.getIn().getHeader("PageBlobRange", PageRange.class)) != null) {
                    blobOffset = range.getStartOffset();
                    blobDataLength = range.getEndOffset() - range.getStartOffset();
                }
                client.downloadRange(blobOffset.longValue(), blobDataLength, os, opts.getAccessCond(), opts.getRequestOpts(), opts.getOpContext());
            }
        }
        finally {
            if (os != null && cfg.isCloseStreamAfterRead()) {
                os.close();
            }
        }
    }

    private static String getBlobFileName(BlobServiceConfiguration cfg) {
        return cfg.getBlobName() + ".blob";
    }

    public static CloudBlobContainer createBlobContainerClient(BlobServiceConfiguration cfg) throws Exception {
        URI uri = BlobServiceUtil.prepareStorageBlobUri(cfg, false);
        StorageCredentials creds = BlobServiceUtil.getAccountCredentials(cfg);
        return new CloudBlobContainer(uri, creds);
    }

    public static CloudBlockBlob createBlockBlobClient(BlobServiceConfiguration cfg) throws Exception {
        CloudBlockBlob client = (CloudBlockBlob)BlobServiceUtil.getConfiguredClient(cfg);
        if (client == null) {
            URI uri = BlobServiceUtil.prepareStorageBlobUri(cfg);
            StorageCredentials creds = BlobServiceUtil.getAccountCredentials(cfg);
            client = new CloudBlockBlob(uri, creds);
        }
        return client;
    }

    public static CloudAppendBlob createAppendBlobClient(BlobServiceConfiguration cfg) throws Exception {
        CloudAppendBlob client = (CloudAppendBlob)BlobServiceUtil.getConfiguredClient(cfg);
        if (client == null) {
            URI uri = BlobServiceUtil.prepareStorageBlobUri(cfg);
            StorageCredentials creds = BlobServiceUtil.getAccountCredentials(cfg);
            client = new CloudAppendBlob(uri, creds);
        }
        return client;
    }

    public static CloudPageBlob createPageBlobClient(BlobServiceConfiguration cfg) throws Exception {
        CloudPageBlob client = (CloudPageBlob)BlobServiceUtil.getConfiguredClient(cfg);
        if (client == null) {
            URI uri = BlobServiceUtil.prepareStorageBlobUri(cfg);
            StorageCredentials creds = BlobServiceUtil.getAccountCredentials(cfg);
            client = new CloudPageBlob(uri, creds);
        }
        return client;
    }

    public static CloudBlob getConfiguredClient(BlobServiceConfiguration cfg) {
        CloudBlob client = cfg.getAzureBlobClient();
        if (client != null) {
            Class<CloudBlockBlob> expectedCls = null;
            if (cfg.getBlobType() == BlobType.blockblob) {
                expectedCls = CloudBlockBlob.class;
            } else if (cfg.getBlobType() == BlobType.appendblob) {
                expectedCls = CloudAppendBlob.class;
            } else if (cfg.getBlobType() == BlobType.pageblob) {
                expectedCls = CloudPageBlob.class;
            }
            if (client.getClass() != expectedCls) {
                throw new IllegalArgumentException("Invalid Client Type");
            }
            if (!client.getUri().equals(BlobServiceUtil.prepareStorageBlobUri(cfg))) {
                throw new IllegalArgumentException("Invalid Client URI");
            }
        }
        return client;
    }

    public static StorageCredentials getAccountCredentials(BlobServiceConfiguration cfg) {
        return cfg.getCredentials();
    }

    public static void configureCloudBlobForRead(CloudBlob client, BlobServiceConfiguration cfg) {
        if (cfg.getStreamReadSize() > 0) {
            client.setStreamMinimumReadSizeInBytes(cfg.getStreamReadSize());
        }
    }

    public static URI prepareStorageBlobUri(BlobServiceConfiguration cfg) {
        return BlobServiceUtil.prepareStorageBlobUri(cfg, true);
    }

    public static URI prepareStorageBlobUri(BlobServiceConfiguration cfg, boolean blobNameRequired) {
        if (blobNameRequired && cfg.getBlobName() == null) {
            throw new IllegalArgumentException("Blob name must be specified");
        }
        StringBuilder uriBuilder = new StringBuilder();
        uriBuilder.append("https://").append(cfg.getAccountName()).append(".blob.core.windows.net").append("/").append(cfg.getContainerName());
        if (cfg.getBlobName() != null) {
            uriBuilder.append("/").append(cfg.getBlobName());
        }
        return URI.create(uriBuilder.toString());
    }

    public static BlobServiceRequestOptions getRequestOptions(Exchange exchange) {
        BlobServiceRequestOptions opts = (BlobServiceRequestOptions)exchange.getIn().getHeader("BlobServiceRequestOptions", BlobServiceRequestOptions.class);
        if (opts != null) {
            return opts;
        }
        opts = new BlobServiceRequestOptions();
        AccessCondition accessCond = (AccessCondition)exchange.getIn().getHeader("BlobAccessCondition", AccessCondition.class);
        BlobRequestOptions requestOpts = (BlobRequestOptions)exchange.getIn().getHeader("BlobRequestOptions", BlobRequestOptions.class);
        OperationContext opContext = (OperationContext)exchange.getIn().getHeader("BlobOperationContext", OperationContext.class);
        opts.setAccessCond(accessCond);
        opts.setOpContext(opContext);
        opts.setRequestOpts(requestOpts);
        return opts;
    }
}

