/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.azure.blob;

import com.microsoft.azure.storage.blob.BlockEntry;
import com.microsoft.azure.storage.blob.BlockSearchMode;
import com.microsoft.azure.storage.core.Base64;
import java.io.InputStream;
import java.util.UUID;

public class BlobBlock {
    private InputStream blockStream;
    private BlockEntry blockEntry;

    public BlobBlock(InputStream blockStream) {
        this(Base64.encode((byte[])UUID.randomUUID().toString().getBytes()), blockStream);
    }

    public BlobBlock(String blockId, InputStream blockStream) {
        this(blockId, BlockSearchMode.LATEST, blockStream);
    }

    public BlobBlock(String blockId, BlockSearchMode searchMode, InputStream blockStream) {
        this(new BlockEntry(blockId, searchMode), blockStream);
    }

    public BlobBlock(BlockEntry blockEntry, InputStream blockStream) {
        this.blockStream = blockStream;
        this.blockEntry = blockEntry;
    }

    public InputStream getBlockStream() {
        return this.blockStream;
    }

    public BlockEntry getBlockEntry() {
        return this.blockEntry;
    }
}

