/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.fhir;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.camel.Exchange;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.DataFormatName;
import org.apache.camel.support.ServiceSupport;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class FhirJsonDataFormat
extends ServiceSupport
implements DataFormat,
DataFormatName {
    private FhirContext fhirContext;
    private String fhirVersion;
    private boolean contentTypeHeader = true;

    public FhirContext getFhirContext() {
        return this.fhirContext;
    }

    public void setFhirContext(FhirContext fhirContext) {
        this.fhirContext = fhirContext;
    }

    public String getFhirVersion() {
        return this.fhirVersion;
    }

    public void setFhirVersion(String fhirVersion) {
        this.fhirVersion = fhirVersion;
    }

    public boolean isContentTypeHeader() {
        return this.contentTypeHeader;
    }

    public void setContentTypeHeader(boolean contentTypeHeader) {
        this.contentTypeHeader = contentTypeHeader;
    }

    public void marshal(Exchange exchange, Object o, OutputStream outputStream) throws Exception {
        IBaseResource iBaseResource = !(o instanceof IBaseResource) ? (IBaseResource)exchange.getContext().getTypeConverter().mandatoryConvertTo(IBaseResource.class, exchange, o) : (IBaseResource)o;
        this.fhirContext.newJsonParser().encodeResourceToWriter(iBaseResource, (Writer)new OutputStreamWriter(outputStream));
        if (this.isContentTypeHeader()) {
            exchange.getMessage().setHeader("Content-Type", (Object)"application/json");
        }
    }

    public Object unmarshal(Exchange exchange, InputStream inputStream) throws Exception {
        return this.fhirContext.newJsonParser().parseResource((Reader)new InputStreamReader(inputStream));
    }

    public String getDataFormatName() {
        return "fhirJson";
    }

    protected void doStart() throws Exception {
        if (this.fhirContext == null && this.fhirVersion != null) {
            FhirVersionEnum version = FhirVersionEnum.valueOf((String)this.fhirVersion);
            this.fhirContext = new FhirContext(version);
        } else if (this.fhirContext == null) {
            this.fhirContext = FhirContext.forDstu3();
        }
    }

    protected void doStop() throws Exception {
    }
}

