/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.client.messaging;

import io.atomix.catalyst.concurrent.Listener;
import io.atomix.group.DistributedGroup;
import io.atomix.group.LocalMember;
import io.atomix.group.messaging.Message;
import io.atomix.group.messaging.MessageConsumer;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.atomix.client.AbstractAtomixClientConsumer;
import org.apache.camel.component.atomix.client.messaging.AtomixMessagingEndpoint;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AtomixMessagingConsumer
extends AbstractAtomixClientConsumer<AtomixMessagingEndpoint> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AtomixMessagingConsumer.class);
    private final List<Listener<Message<Object>>> listeners = new ArrayList<Listener<Message<Object>>>();
    private final String resultHeader;
    private final String groupName;
    private final String memberName;
    private final String channelName;
    private LocalMember localMember;
    private MessageConsumer<Object> consumer;

    public AtomixMessagingConsumer(AtomixMessagingEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.resultHeader = endpoint.getConfiguration().getResultHeader();
        this.groupName = endpoint.getResourceName();
        this.memberName = endpoint.getConfiguration().getMemberName();
        this.channelName = endpoint.getConfiguration().getChannelName();
        ObjectHelper.notNull((Object)this.groupName, (String)"CamelAtomixResourceName");
        ObjectHelper.notNull((Object)this.memberName, (String)"CamelAtomixMemberName");
        ObjectHelper.notNull((Object)this.channelName, (String)"CamelAtomixChannelName");
    }

    protected void doStart() throws Exception {
        super.doStart();
        DistributedGroup group = (DistributedGroup)((AtomixMessagingEndpoint)((Object)this.getAtomixEndpoint())).getAtomix().getGroup(this.groupName, new DistributedGroup.Config(((AtomixMessagingEndpoint)((Object)this.getAtomixEndpoint())).getConfiguration().getResourceOptions(this.groupName)), new DistributedGroup.Options(((AtomixMessagingEndpoint)((Object)this.getAtomixEndpoint())).getConfiguration().getResourceConfig(this.groupName))).join();
        this.localMember = (LocalMember)group.join(this.memberName).join();
        this.consumer = this.localMember.messaging().consumer(this.channelName);
        LOGGER.debug("Subscribe to group: {}, member: {}, channel: {}", new Object[]{this.groupName, this.memberName, this.channelName});
        this.listeners.add((Listener<Message<Object>>)this.consumer.onMessage(this::onMessage));
    }

    protected void doStop() throws Exception {
        this.listeners.forEach(Listener::close);
        if (this.consumer != null) {
            this.consumer.close();
            this.consumer = null;
        }
        super.doStop();
    }

    private void onMessage(Message<Object> message) {
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getIn().setHeader("CamelAtomixEventType", (Object)message.id());
        if (this.resultHeader == null) {
            exchange.getIn().setBody(message.message());
        } else {
            exchange.getIn().setHeader(this.resultHeader, message.message());
        }
        try {
            this.getProcessor().process(exchange);
            message.ack();
        }
        catch (Exception e) {
            message.fail();
            this.getExceptionHandler().handleException((Throwable)e);
        }
    }
}

