/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.etcd.cloud;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Comparator;
import java.util.Map;
import org.apache.camel.impl.cloud.DefaultServiceDefinition;

public class EtcdServiceDefinition
extends DefaultServiceDefinition {
    public static final Comparator<EtcdServiceDefinition> COMPARATOR = EtcdServiceDefinition.comparator();

    @JsonCreator
    public EtcdServiceDefinition(@JsonProperty(value="name") String name, @JsonProperty(value="address") String address, @JsonProperty(value="port") Integer port, @JsonProperty(value="tags") Map<String, String> tags) {
        super(name, address, port.intValue(), tags);
    }

    public static Comparator<EtcdServiceDefinition> comparator() {
        Comparator byAddress = (e1, e2) -> e2.getHost().compareTo(e1.getHost());
        Comparator byPort = (e1, e2) -> Integer.compare(e2.getPort(), e1.getPort());
        return byAddress.thenComparing(byPort);
    }
}

