/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.flink;

import java.util.List;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.flink.DataStreamCallback;
import org.apache.camel.component.flink.FlinkEndpoint;
import org.apache.camel.impl.DefaultProducer;
import org.apache.flink.streaming.api.datastream.DataStream;

public class DataStreamFlinkProducer
extends DefaultProducer {
    public DataStreamFlinkProducer(FlinkEndpoint endpoint) {
        super((Endpoint)endpoint);
    }

    public void process(Exchange exchange) throws Exception {
        DataStream ds = this.resolveDataStream(exchange);
        DataStreamCallback dataStreamCallback = this.resolveDataStreamCallback(exchange);
        Object body = exchange.getIn().getBody();
        Object result = body instanceof List ? dataStreamCallback.onDataStream(ds, ((List)body).toArray(new Object[0])) : dataStreamCallback.onDataStream(ds, body);
        this.collectResults(exchange, result);
    }

    public FlinkEndpoint getEndpoint() {
        return (FlinkEndpoint)super.getEndpoint();
    }

    protected void collectResults(Exchange exchange, Object result) {
        if (result instanceof DataStream) {
            DataStream dsResults = (DataStream)result;
            if (this.getEndpoint().isCollect()) {
                throw new IllegalArgumentException("collect mode not supported for Flink DataStreams.");
            }
            exchange.getIn().setBody(result);
            exchange.getIn().setHeader("CamelFlinkDataStream", result);
        } else {
            exchange.getIn().setBody(result);
        }
    }

    protected DataStream resolveDataStream(Exchange exchange) {
        if (exchange.getIn().getHeader("CamelFlinkDataStream") != null) {
            return (DataStream)exchange.getIn().getHeader("CamelFlinkDataStream");
        }
        if (this.getEndpoint().getDataStream() != null) {
            return this.getEndpoint().getDataStream();
        }
        throw new IllegalArgumentException("No DataStream defined");
    }

    protected DataStreamCallback resolveDataStreamCallback(Exchange exchange) {
        if (exchange.getIn().getHeader("CamelFlinkDataStreamCallback") != null) {
            return (DataStreamCallback)exchange.getIn().getHeader("CamelFlinkDataStreamCallback");
        }
        if (this.getEndpoint().getDataStreamCallback() != null) {
            return this.getEndpoint().getDataStreamCallback();
        }
        throw new IllegalArgumentException("Cannot resolve DataStream callback.");
    }
}

