/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.jolt;

import com.bazaarvoice.jolt.Transform;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jolt.JoltEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.camel.spi.Metadata;
import org.apache.camel.util.ResourceHelper;

public class JoltComponent
extends UriEndpointComponent {
    @Metadata(label="advanced")
    private Transform transform;

    public JoltComponent() {
        super(JoltEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        boolean cache = (Boolean)this.getAndRemoveParameter(parameters, "contentCache", Boolean.class, Boolean.TRUE);
        JoltEndpoint answer = new JoltEndpoint(uri, this, remaining);
        answer.setContentCache(cache);
        answer.setTransform(this.transform);
        if (ResourceHelper.isHttpUri((String)remaining)) {
            remaining = ResourceHelper.appendParameters((String)remaining, parameters);
            answer.setResourceUri(remaining);
        }
        return answer;
    }

    public Transform getTransform() {
        return this.transform;
    }

    public void setTransform(Transform transform) {
        this.transform = transform;
    }
}

