/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.opentracing.decorators;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.opentracing.decorators.AbstractSpanDecorator;

public abstract class AbstractHttpSpanDecorator
extends AbstractSpanDecorator {
    public static final String POST_METHOD = "POST";
    public static final String GET_METHOD = "GET";

    @Override
    public String getOperationName(Exchange exchange, Endpoint endpoint) {
        return AbstractHttpSpanDecorator.getHttpMethod(exchange, endpoint);
    }

    public static String getHttpMethod(Exchange exchange, Endpoint endpoint) {
        Object method = exchange.getIn().getHeader("CamelHttpMethod");
        if (method instanceof String) {
            return (String)method;
        }
        if (exchange.getIn().getHeader("CamelHttpQuery") != null) {
            return GET_METHOD;
        }
        if (endpoint.getEndpointUri().indexOf(63) != -1) {
            return GET_METHOD;
        }
        if (exchange.getIn().getBody() != null) {
            return POST_METHOD;
        }
        return GET_METHOD;
    }

    @Override
    public void pre(Span span, Exchange exchange, Endpoint endpoint) {
        super.pre(span, exchange, endpoint);
        String httpUrl = this.getHttpURL(exchange, endpoint);
        if (httpUrl != null) {
            span.setTag(Tags.HTTP_URL.getKey(), httpUrl);
        }
        span.setTag(Tags.HTTP_METHOD.getKey(), AbstractHttpSpanDecorator.getHttpMethod(exchange, endpoint));
    }

    protected String getHttpURL(Exchange exchange, Endpoint endpoint) {
        Object url = exchange.getIn().getHeader("CamelHttpUrl");
        if (url instanceof String) {
            return (String)url;
        }
        Object uri = exchange.getIn().getHeader("CamelHttpUri");
        if (uri instanceof String) {
            return (String)uri;
        }
        int index = endpoint.getEndpointUri().lastIndexOf("http:");
        if (index != -1) {
            return endpoint.getEndpointUri().substring(index);
        }
        return null;
    }

    @Override
    public void post(Span span, Exchange exchange, Endpoint endpoint) {
        Object responseCode;
        super.post(span, exchange, endpoint);
        if (exchange.hasOut() && (responseCode = exchange.getOut().getHeader("CamelHttpResponseCode")) instanceof Integer) {
            span.setTag(Tags.HTTP_STATUS.getKey(), (Number)((Integer)responseCode));
        }
    }
}

