/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.tika;

import java.net.URI;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Endpoint;
import org.apache.camel.component.tika.TikaConfiguration;
import org.apache.camel.component.tika.TikaEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.tika.config.TikaConfig;

public class TikaComponent
extends UriEndpointComponent {
    private static final String TIKA_CONFIG = "tikaConfig";

    public TikaComponent() {
        super(TikaEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        TikaConfiguration tikaConfiguration = new TikaConfiguration();
        this.setProperties(tikaConfiguration, parameters);
        TikaConfig config = (TikaConfig)this.resolveAndRemoveReferenceParameter(parameters, TIKA_CONFIG, TikaConfig.class);
        if (config != null) {
            tikaConfiguration.setTikaConfig(config);
        }
        tikaConfiguration.setOperation(new URI(uri).getHost());
        return new TikaEndpoint(uri, (Component)this, tikaConfiguration);
    }
}

