/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.common;

import java.io.IOException;
import java.security.GeneralSecurityException;
import javax.net.ssl.SSLSocketFactory;
import org.apache.camel.CamelContext;
import org.apache.camel.component.cxf.common.AbstractTLSClientParameterConfigurer;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.transport.http.HTTPConduit;

public class AbstractSslEndpointConfigurer
extends AbstractTLSClientParameterConfigurer {
    protected final SSLContextParameters sslContextParameters;
    protected final CamelContext camelContext;

    public AbstractSslEndpointConfigurer(SSLContextParameters sslContextParameters, CamelContext camelContext) {
        this.sslContextParameters = sslContextParameters;
        this.camelContext = camelContext;
    }

    protected void setupHttpConduit(HTTPConduit httpConduit) {
        TLSClientParameters tlsClientParameters = this.tryToGetTLSClientParametersFromConduit(httpConduit);
        tlsClientParameters.setSSLSocketFactory(this.tryToGetSSLSocketFactory());
        httpConduit.setTlsClientParameters(tlsClientParameters);
    }

    private SSLSocketFactory tryToGetSSLSocketFactory() {
        try {
            return this.sslContextParameters.createSSLContext(this.camelContext).getSocketFactory();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException("Setting SSL failed", e);
        }
    }
}

