/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.server;

import java.util.function.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.milo.Messages;
import org.apache.camel.component.milo.server.internal.CamelServerItem;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.impl.DefaultMessage;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;

public class MiloServerConsumer
extends DefaultConsumer {
    private final CamelServerItem item;
    private final Consumer<DataValue> writeHandler = this::performWrite;

    public MiloServerConsumer(Endpoint endpoint, Processor processor, CamelServerItem item) {
        super(endpoint, processor);
        this.item = item;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.item.addWriteListener(this.writeHandler);
    }

    protected void doStop() throws Exception {
        this.item.removeWriteListener(this.writeHandler);
        super.doStop();
    }

    protected void performWrite(DataValue value) {
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.setIn((Message)this.mapToMessage(value));
        try {
            this.getAsyncProcessor().process(exchange);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private DefaultMessage mapToMessage(DataValue value) {
        if (value == null) {
            return null;
        }
        DefaultMessage result = new DefaultMessage(this.getEndpoint().getCamelContext());
        Messages.fillFromDataValue(value, result);
        return result;
    }
}

