/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.client;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.milo.NamespaceId;
import org.apache.camel.component.milo.PartialNodeId;
import org.apache.camel.component.milo.client.MiloClientConnection;
import org.apache.camel.component.milo.client.MiloClientItemConfiguration;
import org.apache.camel.impl.DefaultProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiloClientProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(MiloClientProducer.class);
    private final MiloClientConnection connection;
    private final NamespaceId namespaceId;
    private final PartialNodeId partialNodeId;
    private final boolean defaultAwaitWrites;

    public MiloClientProducer(Endpoint endpoint, MiloClientConnection connection, MiloClientItemConfiguration configuration, boolean defaultAwaitWrites) {
        super(endpoint);
        this.connection = connection;
        this.defaultAwaitWrites = defaultAwaitWrites;
        this.namespaceId = configuration.makeNamespaceId();
        this.partialNodeId = configuration.makePartialNodeId();
    }

    public void process(Exchange exchange) throws Exception {
        Message msg = exchange.getIn();
        Object value = msg.getBody();
        LOG.debug("Processing message: {}", value);
        Boolean await = (Boolean)msg.getHeader("await", (Object)this.defaultAwaitWrites, Boolean.class);
        this.connection.writeValue(this.namespaceId, this.partialNodeId, value, await != null ? await : false);
    }
}

