/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.client;

import com.google.common.base.Supplier;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.component.milo.KeyStoreLoader;
import org.apache.camel.component.milo.client.MiloClientConfiguration;
import org.apache.camel.component.milo.client.MiloClientConnection;
import org.apache.camel.component.milo.client.MiloClientEndpoint;
import org.apache.camel.impl.DefaultComponent;
import org.eclipse.milo.opcua.sdk.client.api.config.OpcUaClientConfigBuilder;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MiloClientComponent
extends DefaultComponent {
    private static final Logger LOG = LoggerFactory.getLogger(MiloClientComponent.class);
    private final Map<String, MiloClientConnection> cache = new HashMap<String, MiloClientConnection>();
    private final Multimap<String, MiloClientEndpoint> connectionMap = HashMultimap.create();
    private MiloClientConfiguration defaultConfiguration = new MiloClientConfiguration();

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        MiloClientConfiguration configuration = new MiloClientConfiguration(this.defaultConfiguration);
        configuration.setEndpointUri(remaining);
        this.setProperties(configuration, parameters);
        return this.createEndpoint(uri, configuration, parameters);
    }

    private synchronized MiloClientEndpoint createEndpoint(String uri, MiloClientConfiguration configuration, Map<String, Object> parameters) throws Exception {
        MiloClientConnection connection = this.cache.get(configuration.toCacheId());
        if (connection == null) {
            LOG.info("Cache miss - creating new connection instance: {}", (Object)configuration.toCacheId());
            connection = new MiloClientConnection(configuration, this.mapToClientConfiguration(configuration));
            this.cache.put(configuration.toCacheId(), connection);
        }
        MiloClientEndpoint endpoint = new MiloClientEndpoint(uri, this, connection, configuration.getEndpointUri());
        this.setProperties(endpoint, parameters);
        this.connectionMap.put((Object)configuration.toCacheId(), (Object)endpoint);
        return endpoint;
    }

    private OpcUaClientConfigBuilder mapToClientConfiguration(MiloClientConfiguration configuration) {
        OpcUaClientConfigBuilder builder = new OpcUaClientConfigBuilder();
        this.whenHasText((Supplier<String>)((Supplier)configuration::getApplicationName), value -> builder.setApplicationName(LocalizedText.english((String)value)));
        this.whenHasText((Supplier<String>)((Supplier)configuration::getApplicationUri), arg_0 -> ((OpcUaClientConfigBuilder)builder).setApplicationUri(arg_0));
        this.whenHasText((Supplier<String>)((Supplier)configuration::getProductUri), arg_0 -> ((OpcUaClientConfigBuilder)builder).setProductUri(arg_0));
        if (configuration.getRequestTimeout() != null) {
            builder.setRequestTimeout(Unsigned.uint((long)configuration.getRequestTimeout()));
        }
        if (configuration.getChannelLifetime() != null) {
            builder.setChannelLifetime(Unsigned.uint((long)configuration.getChannelLifetime()));
        }
        this.whenHasText((Supplier<String>)((Supplier)configuration::getSessionName), value -> builder.setSessionName(() -> value));
        if (configuration.getSessionTimeout() != null) {
            builder.setSessionTimeout(UInteger.valueOf((long)configuration.getSessionTimeout()));
        }
        if (configuration.getMaxPendingPublishRequests() != null) {
            builder.setMaxPendingPublishRequests(UInteger.valueOf((long)configuration.getMaxPendingPublishRequests()));
        }
        if (configuration.getMaxResponseMessageSize() != null) {
            builder.setMaxResponseMessageSize(UInteger.valueOf((long)configuration.getMaxPendingPublishRequests()));
        }
        if (configuration.getKeyStoreUrl() != null) {
            this.setKey(configuration, builder);
        }
        return builder;
    }

    private void setKey(MiloClientConfiguration configuration, OpcUaClientConfigBuilder builder) {
        KeyStoreLoader.Result result;
        KeyStoreLoader loader = new KeyStoreLoader();
        try {
            loader.setType(configuration.getKeyStoreType());
            loader.setUrl(configuration.getKeyStoreUrl());
            loader.setKeyStorePassword(configuration.getKeyStorePassword());
            loader.setKeyAlias(configuration.getKeyAlias());
            loader.setKeyPassword(configuration.getKeyPassword());
            result = loader.load();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalStateException("Failed to load key", e);
        }
        if (result == null) {
            throw new IllegalStateException("Key not found in keystore");
        }
        builder.setCertificate(result.getCertificate());
        builder.setKeyPair(result.getKeyPair());
    }

    private void whenHasText(Supplier<String> valueSupplier, Consumer<String> valueConsumer) {
        String value = (String)valueSupplier.get();
        if (value != null && !value.isEmpty()) {
            valueConsumer.accept(value);
        }
    }

    public void setDefaultConfiguration(MiloClientConfiguration defaultConfiguration) {
        this.defaultConfiguration = defaultConfiguration;
    }

    public void setApplicationName(String applicationName) {
        this.defaultConfiguration.setApplicationName(applicationName);
    }

    public void setApplicationUri(String applicationUri) {
        this.defaultConfiguration.setApplicationUri(applicationUri);
    }

    public void setProductUri(String productUri) {
        this.defaultConfiguration.setProductUri(productUri);
    }

    public void setReconnectTimeout(Long reconnectTimeout) {
        this.defaultConfiguration.setRequestTimeout(reconnectTimeout);
    }

    public synchronized void disposed(MiloClientEndpoint endpoint) {
        MiloClientConnection connection = endpoint.getConnection();
        this.connectionMap.remove((Object)connection.getConnectionId(), (Object)endpoint);
        if (!this.connectionMap.containsKey((Object)connection.getConnectionId())) {
            this.cache.remove(connection.getConnectionId());
            try {
                connection.close();
            }
            catch (Exception e) {
                LOG.warn("Failed to close connection", (Throwable)e);
            }
        }
    }
}

