/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.mllp.MllpAcknowledgementReceiveException;
import org.apache.camel.component.mllp.MllpAcknowledgementTimeoutException;
import org.apache.camel.component.mllp.MllpApplicationErrorAcknowledgementException;
import org.apache.camel.component.mllp.MllpApplicationRejectAcknowledgementException;
import org.apache.camel.component.mllp.MllpCommitErrorAcknowledgementException;
import org.apache.camel.component.mllp.MllpCommitRejectAcknowledgementException;
import org.apache.camel.component.mllp.MllpConfiguration;
import org.apache.camel.component.mllp.MllpEndpoint;
import org.apache.camel.component.mllp.MllpException;
import org.apache.camel.component.mllp.MllpInvalidAcknowledgementException;
import org.apache.camel.component.mllp.MllpInvalidMessageException;
import org.apache.camel.component.mllp.MllpNegativeAcknowledgementException;
import org.apache.camel.component.mllp.MllpSocketException;
import org.apache.camel.component.mllp.MllpWriteException;
import org.apache.camel.component.mllp.internal.Hl7Util;
import org.apache.camel.component.mllp.internal.MllpSocketBuffer;
import org.apache.camel.impl.DefaultProducer;

@ManagedResource(description="MLLP Producer")
public class MllpTcpClientProducer
extends DefaultProducer
implements Runnable {
    Socket socket;
    final MllpSocketBuffer mllpBuffer;
    ScheduledExecutorService idleTimeoutExecutor;
    long lastProcessCallTicks = -1L;
    private String cachedLocalAddress;
    private String cachedRemoteAddress;
    private String cachedCombinedAddress;

    public MllpTcpClientProducer(MllpEndpoint endpoint) throws SocketException {
        super((Endpoint)endpoint);
        this.log.trace("Constructing MllpTcpClientProducer for endpoint URI {}", (Object)endpoint.getEndpointUri());
        this.mllpBuffer = new MllpSocketBuffer(endpoint);
    }

    @ManagedAttribute(description="Last activity time")
    public Date getLastActivityTime() {
        return new Date(this.lastProcessCallTicks);
    }

    @ManagedAttribute(description="Connection")
    public String getConnectionAddress() {
        if (this.cachedCombinedAddress != null) {
            return this.cachedCombinedAddress;
        }
        return MllpSocketBuffer.formatAddressString(null, null);
    }

    @ManagedOperation(description="Close Connection")
    public void closeConnection() {
        this.log.info("Close Connection for address {} called via JMX", (Object)this.getConnectionAddress());
        this.mllpBuffer.closeSocket(this.socket);
    }

    @ManagedOperation(description="Reset Connection")
    public void resetConnection() {
        this.log.info("Reset Connection for address {} requested via JMX", (Object)this.getConnectionAddress());
        this.mllpBuffer.resetSocket(this.socket);
    }

    protected void doStart() throws Exception {
        if (this.getConfiguration().hasIdleTimeout()) {
            String fullEndpointKey = this.getEndpoint().getEndpointKey();
            String endpointKey = fullEndpointKey.contains("?") ? fullEndpointKey.substring(0, fullEndpointKey.indexOf(63)) : fullEndpointKey;
            this.idleTimeoutExecutor = Executors.newSingleThreadScheduledExecutor(new IdleTimeoutThreadFactory(endpointKey));
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        if (this.idleTimeoutExecutor != null) {
            this.idleTimeoutExecutor.shutdown();
            this.idleTimeoutExecutor = null;
        }
        this.mllpBuffer.resetSocket(this.socket);
        super.doStop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void process(Exchange exchange) throws Exception {
        block37: {
            this.log.trace("Processing Exchange {}", (Object)exchange.getExchangeId());
            this.getEndpoint().updateLastConnectionActivityTicks();
            Message message = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
            this.getEndpoint().checkBeforeSendProperties(exchange, this.socket, this.log);
            try {
                byte[] hl7MessageBytes;
                block38: {
                    this.checkConnection();
                    if (this.cachedLocalAddress != null) {
                        message.setHeader("CamelMllpLocalAddress", (Object)this.cachedLocalAddress);
                    }
                    if (this.cachedRemoteAddress != null) {
                        message.setHeader("CamelMllpRemoteAddress", (Object)this.cachedRemoteAddress);
                    }
                    hl7MessageBytes = null;
                    Object messageBody = message.getBody();
                    if (messageBody == null) {
                        exchange.setException((Throwable)new MllpInvalidMessageException("message body is null", hl7MessageBytes));
                        return;
                    }
                    if (messageBody instanceof byte[]) {
                        hl7MessageBytes = (byte[])messageBody;
                    } else if (messageBody instanceof String) {
                        String stringBody = (String)messageBody;
                        hl7MessageBytes = stringBody.getBytes(this.getConfiguration().getCharset(exchange));
                        if (this.getConfiguration().hasCharsetName()) {
                            exchange.setProperty("CamelCharsetName", (Object)this.getConfiguration().getCharsetName());
                        }
                    }
                    this.log.debug("Sending message to external system");
                    this.getEndpoint().updateLastConnectionEstablishedTicks();
                    try {
                        this.mllpBuffer.setEnvelopedMessage(hl7MessageBytes);
                        this.mllpBuffer.writeTo(this.socket);
                    }
                    catch (MllpSocketException writeEx) {
                        this.log.debug("Exception encountered reading acknowledgement - attempting reconnect", (Throwable)writeEx);
                        try {
                            this.checkConnection();
                            this.log.trace("Reconnected succeeded - resending payload");
                            try {
                                this.mllpBuffer.writeTo(this.socket);
                            }
                            catch (MllpSocketException retryWriteEx) {
                                exchange.setException((Throwable)retryWriteEx);
                            }
                        }
                        catch (IOException reconnectEx) {
                            this.log.debug("Reconnected failed - sending exception to exchange", (Throwable)reconnectEx);
                            exchange.setException((Throwable)reconnectEx);
                        }
                    }
                    if (exchange.getException() != null) break block37;
                    this.log.debug("Reading acknowledgement from external system");
                    try {
                        this.mllpBuffer.reset();
                        this.mllpBuffer.readFrom(this.socket);
                    }
                    catch (MllpSocketException receiveAckEx) {
                        this.log.debug("Exception encountered reading acknowledgement - attempting reconnect", (Throwable)receiveAckEx);
                        try {
                            this.checkConnection();
                        }
                        catch (IOException reconnectEx) {
                            this.log.debug("Reconnected failed - sending original exception to exchange", (Throwable)reconnectEx);
                            exchange.setException((Throwable)new MllpAcknowledgementReceiveException("Exception encountered reading acknowledgement", hl7MessageBytes, (Throwable)receiveAckEx));
                        }
                        if (exchange.getException() != null) break block38;
                        this.log.trace("Reconnected succeeded - resending payload");
                        try {
                            this.mllpBuffer.setEnvelopedMessage(hl7MessageBytes);
                            this.mllpBuffer.writeTo(this.socket);
                        }
                        catch (MllpSocketException writeRetryEx) {
                            exchange.setException((Throwable)new MllpWriteException("Failed to write HL7 message to socket", hl7MessageBytes, writeRetryEx));
                        }
                        if (exchange.getException() != null) break block38;
                        this.log.trace("Resend succeeded - reading acknowledgement");
                        try {
                            this.mllpBuffer.reset();
                            this.mllpBuffer.readFrom(this.socket);
                        }
                        catch (MllpSocketException secondReceiveEx) {
                            if (this.mllpBuffer.isEmpty()) {
                                MllpAcknowledgementReceiveException exchangeEx = new MllpAcknowledgementReceiveException("Exception encountered receiving Acknowledgement", hl7MessageBytes, (Throwable)secondReceiveEx);
                                exchange.setException((Throwable)exchangeEx);
                                break block38;
                            }
                            byte[] partialAcknowledgment = this.mllpBuffer.toByteArray();
                            this.mllpBuffer.reset();
                            MllpAcknowledgementReceiveException exchangeEx = new MllpAcknowledgementReceiveException("Exception encountered receiving complete Acknowledgement", hl7MessageBytes, partialAcknowledgment, secondReceiveEx);
                            exchange.setException((Throwable)exchangeEx);
                        }
                    }
                    catch (SocketTimeoutException timeoutEx) {
                        if (this.mllpBuffer.isEmpty()) {
                            exchange.setException((Throwable)new MllpAcknowledgementTimeoutException("Timeout receiving HL7 Acknowledgement", hl7MessageBytes, (Throwable)timeoutEx));
                        } else {
                            exchange.setException((Throwable)new MllpAcknowledgementTimeoutException("Timeout receiving complete HL7 Acknowledgement", hl7MessageBytes, this.mllpBuffer.toByteArray(), timeoutEx));
                            this.mllpBuffer.reset();
                        }
                        this.mllpBuffer.resetSocket(this.socket);
                    }
                }
                if (exchange.getException() != null) break block37;
                if (this.mllpBuffer.hasCompleteEnvelope()) {
                    String exceptionMessage;
                    byte[] acknowledgementBytes = this.mllpBuffer.toMllpPayload();
                    this.log.debug("Populating message headers with the acknowledgement from the external system");
                    message.setHeader("CamelMllpAcknowledgement", (Object)acknowledgementBytes);
                    if (acknowledgementBytes != null && acknowledgementBytes.length > 0) {
                        message.setHeader("CamelMllpAcknowledgementString", (Object)new String(acknowledgementBytes, this.getConfiguration().getCharset(exchange, acknowledgementBytes)));
                    } else {
                        message.setHeader("CamelMllpAcknowledgementString", (Object)"");
                    }
                    if (this.getConfiguration().isValidatePayload() && (exceptionMessage = Hl7Util.generateInvalidPayloadExceptionMessage(acknowledgementBytes)) != null) {
                        exchange.setException((Throwable)new MllpInvalidAcknowledgementException(exceptionMessage, hl7MessageBytes, acknowledgementBytes));
                    }
                    if (exchange.getException() != null) break block37;
                    this.log.debug("Processing the acknowledgement from the external system");
                    try {
                        message.setHeader("CamelMllpAcknowledgementType", (Object)this.processAcknowledgment(hl7MessageBytes, acknowledgementBytes));
                    }
                    catch (MllpNegativeAcknowledgementException nackEx) {
                        message.setHeader("CamelMllpAcknowledgementType", (Object)nackEx.getAcknowledgmentType());
                        exchange.setException((Throwable)nackEx);
                    }
                    this.getEndpoint().checkAfterSendProperties(exchange, this.socket, this.log);
                    break block37;
                }
                exchange.setException((Throwable)new MllpInvalidAcknowledgementException("Invalid acknowledgement received", hl7MessageBytes, this.mllpBuffer.toByteArrayAndReset()));
            }
            catch (IOException ioEx) {
                exchange.setException((Throwable)ioEx);
                this.mllpBuffer.resetSocket(this.socket);
            }
            finally {
                this.mllpBuffer.reset();
            }
        }
    }

    private String processAcknowledgment(byte[] hl7MessageBytes, byte[] hl7AcknowledgementBytes) throws MllpException {
        String acknowledgementType = "";
        if (hl7AcknowledgementBytes != null && hl7AcknowledgementBytes.length > 3) {
            byte fieldDelim = hl7AcknowledgementBytes[3];
            int msaStartIndex = -1;
            for (int i = 0; i < hl7AcknowledgementBytes.length; ++i) {
                if (13 != hl7AcknowledgementBytes[i]) continue;
                int bM = 77;
                int bS = 83;
                int bC = 67;
                int bA = 65;
                int bE = 69;
                int bR = 82;
                if (hl7AcknowledgementBytes.length <= i + 7 || 77 != hl7AcknowledgementBytes[i + 1] || 83 != hl7AcknowledgementBytes[i + 2] || 65 != hl7AcknowledgementBytes[i + 3] || fieldDelim != hl7AcknowledgementBytes[i + 4]) continue;
                msaStartIndex = i + 1;
                if (65 != hl7AcknowledgementBytes[i + 5] && 67 != hl7AcknowledgementBytes[i + 5]) {
                    String errorMessage = "Unsupported acknowledgement type: " + new String(hl7AcknowledgementBytes, i + 5, 2);
                    throw new MllpInvalidAcknowledgementException(errorMessage, hl7MessageBytes, hl7AcknowledgementBytes);
                }
                switch (hl7AcknowledgementBytes[i + 6]) {
                    case 65: {
                        if (65 == hl7AcknowledgementBytes[i + 5]) {
                            acknowledgementType = "AA";
                            break;
                        }
                        acknowledgementType = "CA";
                        break;
                    }
                    case 69: {
                        if (65 == hl7AcknowledgementBytes[i + 5]) {
                            throw new MllpApplicationErrorAcknowledgementException(hl7MessageBytes, hl7AcknowledgementBytes);
                        }
                        throw new MllpCommitErrorAcknowledgementException(hl7MessageBytes, hl7AcknowledgementBytes);
                    }
                    case 82: {
                        if (65 == hl7AcknowledgementBytes[i + 5]) {
                            throw new MllpApplicationRejectAcknowledgementException(hl7MessageBytes, hl7AcknowledgementBytes);
                        }
                        throw new MllpCommitRejectAcknowledgementException(hl7MessageBytes, hl7AcknowledgementBytes);
                    }
                    default: {
                        String errorMessage = "Unsupported acknowledgement type: " + new String(hl7AcknowledgementBytes, i + 5, 2);
                        throw new MllpInvalidAcknowledgementException(errorMessage, hl7MessageBytes, hl7AcknowledgementBytes);
                    }
                }
                break;
            }
            if (-1 == msaStartIndex && this.getConfiguration().isValidatePayload()) {
                throw new MllpInvalidAcknowledgementException("MSA Not found in acknowledgement", hl7MessageBytes, hl7AcknowledgementBytes);
            }
        }
        return acknowledgementType;
    }

    void checkConnection() throws IOException {
        if (null == this.socket || this.socket.isClosed() || !this.socket.isConnected()) {
            SocketAddress remoteSocketAddress;
            this.socket = new Socket();
            if (this.getConfiguration().hasKeepAlive()) {
                this.socket.setKeepAlive(this.getConfiguration().getKeepAlive());
            }
            if (this.getConfiguration().hasTcpNoDelay()) {
                this.socket.setTcpNoDelay(this.getConfiguration().getTcpNoDelay());
            }
            if (this.getConfiguration().hasReceiveBufferSize()) {
                this.socket.setReceiveBufferSize(this.getConfiguration().getReceiveBufferSize());
            }
            if (this.getConfiguration().hasSendBufferSize()) {
                this.socket.setSendBufferSize(this.getConfiguration().getSendBufferSize());
            }
            if (this.getConfiguration().hasReuseAddress()) {
                this.socket.setReuseAddress(this.getConfiguration().getReuseAddress());
            }
            this.socket.setSoLinger(false, -1);
            InetSocketAddress socketAddress = null == this.getEndpoint().getHostname() ? new InetSocketAddress(this.getEndpoint().getPort()) : new InetSocketAddress(this.getEndpoint().getHostname(), this.getEndpoint().getPort());
            this.socket.connect(socketAddress, this.getConfiguration().getConnectTimeout());
            SocketAddress localSocketAddress = this.socket.getLocalSocketAddress();
            if (localSocketAddress != null) {
                this.cachedLocalAddress = localSocketAddress.toString();
            }
            if ((remoteSocketAddress = this.socket.getRemoteSocketAddress()) != null) {
                this.cachedRemoteAddress = remoteSocketAddress.toString();
            }
            this.cachedCombinedAddress = MllpSocketBuffer.formatAddressString(localSocketAddress, remoteSocketAddress);
            this.log.info("checkConnection() - established new connection {}", (Object)this.cachedCombinedAddress);
            this.getEndpoint().updateLastConnectionEstablishedTicks();
            if (this.getConfiguration().hasIdleTimeout()) {
                this.idleTimeoutExecutor.schedule(this, (long)this.getConfiguration().getIdleTimeout().intValue(), TimeUnit.MILLISECONDS);
            }
        } else {
            this.log.debug("checkConnection() - Connection is still valid - no new connection required");
        }
    }

    @Override
    public synchronized void run() {
        if (this.getConfiguration().hasIdleTimeout() && null != this.socket && !this.socket.isClosed() && this.socket.isConnected()) {
            if (this.lastProcessCallTicks > 0L) {
                long idleTime = System.currentTimeMillis() - this.lastProcessCallTicks;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Checking {} for idle connection: {} - {}", new Object[]{this.getConnectionAddress(), idleTime, this.getConfiguration().getIdleTimeout()});
                }
                if (idleTime >= (long)this.getConfiguration().getIdleTimeout().intValue()) {
                    this.log.info("MLLP Connection idle time of '{}' milliseconds met or exceeded the idle producer timeout of '{}' milliseconds - resetting conection", (Object)idleTime, (Object)this.getConfiguration().getIdleTimeout());
                    this.mllpBuffer.resetSocket(this.socket);
                } else {
                    long minDelay = 100L;
                    long delay = Long.min(Long.max(minDelay, (long)this.getConfiguration().getIdleTimeout().intValue() - idleTime), this.getConfiguration().getIdleTimeout().intValue());
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Scheduling idle producer connection check of {} in {} milliseconds", (Object)this.getConnectionAddress(), (Object)delay);
                    }
                    this.idleTimeoutExecutor.schedule(this, delay, TimeUnit.MILLISECONDS);
                }
            } else {
                this.log.debug("Scheduling idle producer connection check in {} milliseconds", (Object)this.getConfiguration().getIdleTimeout());
                this.idleTimeoutExecutor.schedule(this, (long)this.getConfiguration().getIdleTimeout().intValue(), TimeUnit.MILLISECONDS);
            }
        }
    }

    public MllpEndpoint getEndpoint() {
        return (MllpEndpoint)super.getEndpoint();
    }

    public MllpConfiguration getConfiguration() {
        return this.getEndpoint().getConfiguration();
    }

    static class IdleTimeoutThreadFactory
    implements ThreadFactory {
        final String endpointKey;

        IdleTimeoutThreadFactory(String endpointKey) {
            this.endpointKey = endpointKey;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread timeoutThread = Executors.defaultThreadFactory().newThread(r);
            timeoutThread.setName(String.format("%s[%s]-idle-timeout-thread", MllpTcpClientProducer.class.getSimpleName(), this.endpointKey));
            return timeoutThread;
        }
    }
}

