/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.thrift.server;

import java.lang.reflect.Method;
import java.util.Arrays;
import javassist.util.proxy.MethodHandler;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.thrift.ThriftConsumer;
import org.apache.camel.component.thrift.ThriftEndpoint;
import org.apache.camel.component.thrift.ThriftUtils;
import org.apache.thrift.TApplicationException;
import org.apache.thrift.TException;
import org.apache.thrift.async.AsyncMethodCallback;

public class ThriftMethodHandler
implements MethodHandler {
    private final ThriftEndpoint endpoint;
    private final ThriftConsumer consumer;

    public ThriftMethodHandler(ThriftEndpoint endpoint, ThriftConsumer consumer) {
        this.endpoint = endpoint;
        this.consumer = consumer;
    }

    public Object invoke(Object self, Method thisMethod, Method proceed, Object[] args) throws Throwable {
        if (proceed == null) {
            Exchange exchange;
            AsyncMethodCallback callback;
            if (args.length > 0 && args[args.length - 1] instanceof AsyncMethodCallback) {
                callback = (AsyncMethodCallback)args[args.length - 1];
                exchange = this.endpoint.createExchange();
                if (args.length >= 2) {
                    exchange.getIn().setBody(Arrays.asList(Arrays.copyOfRange(args, 0, args.length - 1)));
                } else {
                    exchange.getIn().setBody(null);
                }
            } else {
                Exchange exchange2 = this.endpoint.createExchange();
                exchange2.getIn().setBody(Arrays.asList(args));
                exchange2.getIn().setHeader("CamelThriftMethodName", (Object)thisMethod.getName());
                this.consumer.getProcessor().process(exchange2);
                Object responseBody = exchange2.getIn().getBody(thisMethod.getReturnType());
                if (responseBody == null && !thisMethod.getReturnType().equals(Void.TYPE)) {
                    throw new TApplicationException("Return type requires not empty body");
                }
                return responseBody;
            }
            exchange.getIn().setHeader("CamelThriftMethodName", (Object)thisMethod.getName());
            this.consumer.process(exchange, doneSync -> {
                Message message = null;
                Object response = null;
                Exception exception = exchange.getException();
                if (exception != null) {
                    callback.onError(exception);
                }
                if ((message = exchange.hasOut() ? exchange.getOut() : exchange.getIn()) != null) {
                    Class returnType = ThriftUtils.findMethodReturnType(args[args.length - 1].getClass(), "onComplete");
                    if (returnType != null) {
                        response = message.getBody(returnType);
                    } else {
                        callback.onError((Exception)((Object)new TException("Unable to detect method return type")));
                    }
                } else {
                    callback.onError((Exception)((Object)new TException("Unable process null message")));
                }
                callback.onComplete(response);
            });
            return null;
        }
        return proceed.invoke(self, args);
    }
}

