/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.olingo4;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.olingo4.Olingo4Configuration;
import org.apache.camel.component.olingo4.Olingo4Endpoint;
import org.apache.camel.component.olingo4.api.Olingo4ResponseHandler;
import org.apache.camel.component.olingo4.internal.Olingo4ApiName;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.component.AbstractApiConsumer;
import org.apache.camel.util.component.AbstractApiEndpoint;
import org.apache.camel.util.component.ApiConsumerHelper;

public class Olingo4Consumer
extends AbstractApiConsumer<Olingo4ApiName, Olingo4Configuration> {
    public Olingo4Consumer(Olingo4Endpoint endpoint, Processor processor) {
        super((AbstractApiEndpoint)endpoint, processor);
    }

    protected int poll() throws Exception {
        HashMap<String, 1> args = new HashMap<String, 1>();
        args.putAll(this.endpoint.getEndpointProperties());
        this.endpoint.interceptProperties(args);
        this.interceptProperties(args);
        try {
            final CountDownLatch latch = new CountDownLatch(1);
            final Object[] result = new Object[1];
            final Exception[] error = new Exception[1];
            args.put("responseHandler", new Olingo4ResponseHandler<Object>(){

                public void onResponse(Object response, Map<String, String> responseHeaders) {
                    result[0] = response;
                    latch.countDown();
                }

                public void onException(Exception ex) {
                    error[0] = ex;
                    latch.countDown();
                }

                public void onCanceled() {
                    error[0] = new RuntimeCamelException("OData HTTP Request cancelled");
                    latch.countDown();
                }
            });
            this.doInvokeMethod(args);
            latch.await();
            if (error[0] != null) {
                throw error[0];
            }
            return ApiConsumerHelper.getResultsProcessed((DefaultConsumer)this, (Object)result[0], (boolean)this.isSplitResult());
        }
        catch (Throwable t) {
            throw ObjectHelper.wrapRuntimeCamelException((Throwable)t);
        }
    }
}

