/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.guice.jndi;

import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.ProvisionException;
import com.google.inject.Scopes;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.spi.InitialContextFactory;
import org.apache.camel.guice.inject.Injectors;
import org.apache.camel.guice.jndi.JndiBindings;
import org.apache.camel.guice.jndi.internal.JndiContext;

public class GuiceInitialContextFactory
implements InitialContextFactory {
    public static final String NAME_PREFIX = "org.guiceyfruit.jndi/";

    @Override
    public Context getInitialContext(final Hashtable<?, ?> environment) throws NamingException {
        try {
            Injector injector = Injectors.createInjector(environment, new Module[]{new AbstractModule(){

                protected void configure() {
                    this.bind(Context.class).toProvider((Provider)new Provider<Context>(){
                        @Inject
                        Injector injector;

                        public Context get() {
                            JndiContext context = new JndiContext(environment);
                            Properties jndiNames = GuiceInitialContextFactory.this.createJndiNamesProperties(environment);
                            try {
                                JndiBindings.bindInjectorAndBindings(context, this.injector, jndiNames);
                                return context;
                            }
                            catch (NamingException e) {
                                throw new ProvisionException("Failed to create JNDI bindings. Reason: " + e, (Throwable)e);
                            }
                        }
                    }).in(Scopes.SINGLETON);
                }
            }});
            return (Context)injector.getInstance(Context.class);
        }
        catch (Exception e) {
            NamingException exception = new NamingException(e.getMessage());
            exception.initCause(e);
            throw exception;
        }
    }

    private Properties createJndiNamesProperties(Hashtable environment) {
        Set set = environment.entrySet();
        Properties answer = new Properties();
        for (Map.Entry entry : set) {
            String key = entry.getKey().toString();
            if (!key.startsWith(NAME_PREFIX)) continue;
            String name = key.substring(NAME_PREFIX.length());
            Object value = entry.getValue();
            answer.put(name, value);
        }
        return answer;
    }
}

