/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.braintree.internal;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BraintreeLogHandler
extends Handler {
    public static final Handler INSTANCE = new BraintreeLogHandler();
    public static final Level DEFAULT_LOGGER_VERSION = Level.WARNING;
    public static final String DEFAULT_LOGGER_NAME = "org.apache.camel.component.braintree.camel-braintree";
    private static final int TRACE_LEVEL_THRESHOLD = Level.FINEST.intValue();
    private static final int DEBUG_LEVEL_THRESHOLD = Level.FINE.intValue();
    private static final int INFO_LEVEL_THRESHOLD = Level.INFO.intValue();
    private static final int WARN_LEVEL_THRESHOLD = Level.WARNING.intValue();

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void publish(LogRecord record) {
        if (record != null) {
            Logger logger = this.getLogger(record);
            String message = this.formatMessage(record);
            int level = record.getLevel().intValue();
            if (level <= TRACE_LEVEL_THRESHOLD) {
                logger.trace(message, record.getThrown());
            } else if (level <= DEBUG_LEVEL_THRESHOLD) {
                logger.debug(message, record.getThrown());
            } else if (level <= INFO_LEVEL_THRESHOLD) {
                logger.info(message, record.getThrown());
            } else if (level <= WARN_LEVEL_THRESHOLD) {
                logger.warn(message, record.getThrown());
            } else {
                logger.error(message, record.getThrown());
            }
        }
    }

    private Logger getLogger(LogRecord record) {
        String name = record.getLoggerName();
        if (name == null) {
            name = DEFAULT_LOGGER_NAME;
        }
        return LoggerFactory.getLogger((String)name);
    }

    private String formatMessage(LogRecord record) {
        String message = record.getMessage();
        if (message != null) {
            Object[] params;
            ResourceBundle bundle = record.getResourceBundle();
            if (bundle != null) {
                try {
                    message = bundle.getString(message);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            if ((params = record.getParameters()) != null && params.length > 0) {
                try {
                    message = MessageFormat.format(message, params);
                }
                catch (IllegalArgumentException e) {
                    return message;
                }
            }
        } else {
            message = "";
        }
        return message;
    }
}

