/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.kubernetes;

import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.kubernetes.AbstractKubernetesEndpoint;
import org.apache.camel.component.kubernetes.KubernetesComponent;
import org.apache.camel.component.kubernetes.KubernetesConfiguration;
import org.apache.camel.component.kubernetes.build_configs.KubernetesBuildConfigsProducer;
import org.apache.camel.component.kubernetes.builds.KubernetesBuildsProducer;
import org.apache.camel.component.kubernetes.config_maps.KubernetesConfigMapsProducer;
import org.apache.camel.component.kubernetes.namespaces.KubernetesNamespacesConsumer;
import org.apache.camel.component.kubernetes.namespaces.KubernetesNamespacesProducer;
import org.apache.camel.component.kubernetes.nodes.KubernetesNodesConsumer;
import org.apache.camel.component.kubernetes.nodes.KubernetesNodesProducer;
import org.apache.camel.component.kubernetes.persistent_volumes.KubernetesPersistentVolumesProducer;
import org.apache.camel.component.kubernetes.persistent_volumes_claims.KubernetesPersistentVolumesClaimsProducer;
import org.apache.camel.component.kubernetes.pods.KubernetesPodsConsumer;
import org.apache.camel.component.kubernetes.pods.KubernetesPodsProducer;
import org.apache.camel.component.kubernetes.replication_controllers.KubernetesReplicationControllersConsumer;
import org.apache.camel.component.kubernetes.replication_controllers.KubernetesReplicationControllersProducer;
import org.apache.camel.component.kubernetes.resources_quota.KubernetesResourcesQuotaProducer;
import org.apache.camel.component.kubernetes.secrets.KubernetesSecretsProducer;
import org.apache.camel.component.kubernetes.service_accounts.KubernetesServiceAccountsProducer;
import org.apache.camel.component.kubernetes.services.KubernetesServicesConsumer;
import org.apache.camel.component.kubernetes.services.KubernetesServicesProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@UriEndpoint(firstVersion="2.17.0", scheme="kubernetes", title="Kubernetes", syntax="kubernetes:masterUrl", label="container,cloud,paas")
public class KubernetesEndpoint
extends AbstractKubernetesEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(KubernetesEndpoint.class);
    @UriParam(enums="namespaces,services,replicationControllers,pods,persistentVolumes,persistentVolumesClaims,secrets,resourcesQuota,serviceAccounts,nodes,configMaps,builds,buildConfigs")
    @Metadata(required="true")
    private String category;

    public KubernetesEndpoint(String uri, KubernetesComponent component, KubernetesConfiguration config) {
        super(uri, component, config);
        this.category = config.getCategory();
    }

    public Producer createProducer() throws Exception {
        if (ObjectHelper.isEmpty((Object)this.category)) {
            throw new IllegalArgumentException("A producer category must be specified");
        }
        switch (this.category) {
            case "namespaces": {
                return new KubernetesNamespacesProducer(this);
            }
            case "services": {
                return new KubernetesServicesProducer(this);
            }
            case "replicationControllers": {
                return new KubernetesReplicationControllersProducer(this);
            }
            case "pods": {
                return new KubernetesPodsProducer(this);
            }
            case "persistentVolumes": {
                return new KubernetesPersistentVolumesProducer(this);
            }
            case "persistentVolumesClaims": {
                return new KubernetesPersistentVolumesClaimsProducer(this);
            }
            case "secrets": {
                return new KubernetesSecretsProducer(this);
            }
            case "resourcesQuota": {
                return new KubernetesResourcesQuotaProducer(this);
            }
            case "serviceAccounts": {
                return new KubernetesServiceAccountsProducer(this);
            }
            case "nodes": {
                return new KubernetesNodesProducer(this);
            }
            case "configMaps": {
                return new KubernetesConfigMapsProducer(this);
            }
            case "builds": {
                return new KubernetesBuildsProducer(this);
            }
            case "buildConfigs": {
                return new KubernetesBuildConfigsProducer(this);
            }
        }
        throw new IllegalArgumentException("The " + this.category + " producer category doesn't exist");
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        if (ObjectHelper.isEmpty((Object)this.category)) {
            throw new IllegalArgumentException("A consumer category must be specified");
        }
        switch (this.category) {
            case "pods": {
                return new KubernetesPodsConsumer(this, processor);
            }
            case "services": {
                return new KubernetesServicesConsumer(this, processor);
            }
            case "replicationControllers": {
                return new KubernetesReplicationControllersConsumer(this, processor);
            }
            case "namespaces": {
                return new KubernetesNamespacesConsumer(this, processor);
            }
            case "nodes": {
                return new KubernetesNodesConsumer(this, processor);
            }
        }
        throw new IllegalArgumentException("The " + this.category + " consumer category doesn't exist");
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }
}

