/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.thrift.server;

import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.server.ServerContext;
import org.apache.thrift.server.TServer;
import org.apache.thrift.server.TServerEventHandler;
import org.apache.thrift.transport.TSaslTransportException;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftThreadPoolServer
extends TServer {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ThriftThreadPoolServer.class.getName());
    private final ExecutorService invoker;
    private final CamelContext context;
    private final ExecutorService startExecutor;
    private final TimeUnit requestTimeoutUnit;
    private final long requestTimeout;
    private final long beBackoffSlotInMillis;
    private Random random = new Random(System.currentTimeMillis());

    public ThriftThreadPoolServer(Args args) {
        super((TServer.AbstractServerArgs)args);
        this.requestTimeoutUnit = args.requestTimeoutUnit;
        this.requestTimeout = args.requestTimeout;
        this.beBackoffSlotInMillis = args.beBackoffSlotLengthUnit.toMillis(args.beBackoffSlotLength);
        this.context = args.context;
        this.invoker = args.executorService;
        this.startExecutor = args.startThreadPool;
    }

    public void serve() {
        try {
            this.serverTransport_.listen();
        }
        catch (TTransportException ttx) {
            LOGGER.error("Error occurred during listening.", (Throwable)ttx);
            return;
        }
        if (this.eventHandler_ != null) {
            this.eventHandler_.preServe();
        }
        this.startExecutor.execute(() -> {
            this.stopped_ = false;
            this.setServing(true);
            this.waitForShutdown();
            this.context.getExecutorServiceManager().shutdownGraceful(this.invoker);
            this.setServing(false);
        });
    }

    public void waitForShutdown() {
        int failureCount = 0;
        block6: while (!this.stopped_) {
            try {
                TTransport client = this.serverTransport_.accept();
                WorkerProcess wp = new WorkerProcess(client);
                int retryCount = 0;
                long remainTimeInMillis = this.requestTimeoutUnit.toMillis(this.requestTimeout);
                while (true) {
                    try {
                        this.invoker.execute(wp);
                        continue block6;
                    }
                    catch (Throwable t) {
                        if (t instanceof RejectedExecutionException) {
                            ++retryCount;
                            try {
                                if (remainTimeInMillis > 0L) {
                                    long sleepTimeInMillis = (long)(this.random.nextDouble() * (double)(1L << Math.min(retryCount, 20))) * this.beBackoffSlotInMillis;
                                    sleepTimeInMillis = Math.min(sleepTimeInMillis, remainTimeInMillis);
                                    TimeUnit.MILLISECONDS.sleep(sleepTimeInMillis);
                                    remainTimeInMillis -= sleepTimeInMillis;
                                    continue;
                                }
                                client.close();
                                wp = null;
                                LOGGER.warn("Task has been rejected by ExecutorService " + retryCount + " times till timedout, reason: " + t);
                            }
                            catch (InterruptedException e) {
                                LOGGER.warn("Interrupted while waiting to place client on executor queue.");
                                Thread.currentThread().interrupt();
                            }
                            continue block6;
                        }
                        if (t instanceof Error) {
                            LOGGER.error("ExecutorService threw error: " + t, t);
                            throw (Error)t;
                        }
                        LOGGER.warn("ExecutorService threw error: " + t, t);
                    }
                    break;
                }
            }
            catch (TTransportException ttx) {
                if (this.stopped_) continue;
                ++failureCount;
                LOGGER.warn("Transport error occurred during acceptance of message.", (Throwable)ttx);
            }
        }
    }

    public void stop() {
        this.stopped_ = true;
        this.serverTransport_.interrupt();
        this.context.getExecutorServiceManager().shutdownGraceful(this.startExecutor);
    }

    private final class WorkerProcess
    implements Runnable {
        private TTransport client;

        private WorkerProcess(TTransport client) {
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            TTransport outputTransport;
            TTransport inputTransport;
            block25: {
                TProcessor processor = null;
                inputTransport = null;
                outputTransport = null;
                TProtocol inputProtocol = null;
                TProtocol outputProtocol = null;
                TServerEventHandler eventHandler = null;
                ServerContext connectionContext = null;
                try {
                    processor = ThriftThreadPoolServer.this.processorFactory_.getProcessor(this.client);
                    inputTransport = ThriftThreadPoolServer.this.inputTransportFactory_.getTransport(this.client);
                    outputTransport = ThriftThreadPoolServer.this.outputTransportFactory_.getTransport(this.client);
                    inputProtocol = ThriftThreadPoolServer.this.inputProtocolFactory_.getProtocol(inputTransport);
                    outputProtocol = ThriftThreadPoolServer.this.outputProtocolFactory_.getProtocol(outputTransport);
                    eventHandler = ThriftThreadPoolServer.this.getEventHandler();
                    if (eventHandler != null) {
                        connectionContext = eventHandler.createContext(inputProtocol, outputProtocol);
                    }
                    do {
                        if (eventHandler == null) continue;
                        eventHandler.processContext(connectionContext, inputTransport, outputTransport);
                    } while (!ThriftThreadPoolServer.this.stopped_ && processor.process(inputProtocol, outputProtocol));
                    if (eventHandler == null) break block25;
                }
                catch (TSaslTransportException tSaslTransportException) {
                    if (eventHandler != null) {
                        eventHandler.deleteContext(connectionContext, inputProtocol, outputProtocol);
                    }
                    if (inputTransport != null) {
                        inputTransport.close();
                    }
                    if (outputTransport != null) {
                        outputTransport.close();
                    }
                    if (!this.client.isOpen()) return;
                    this.client.close();
                    return;
                    catch (TTransportException tTransportException) {
                        if (eventHandler != null) {
                            eventHandler.deleteContext(connectionContext, inputProtocol, outputProtocol);
                        }
                        if (inputTransport != null) {
                            inputTransport.close();
                        }
                        if (outputTransport != null) {
                            outputTransport.close();
                        }
                        if (!this.client.isOpen()) return;
                        this.client.close();
                        return;
                        catch (TException tx) {
                            LOGGER.error("Thrift error occurred during processing of message.", (Throwable)tx);
                            return;
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                            catch (Exception x) {
                                LOGGER.error("Error occurred during processing of message.", (Throwable)x);
                                return;
                            }
                        }
                    }
                }
                finally {
                    if (eventHandler != null) {
                        eventHandler.deleteContext(connectionContext, inputProtocol, outputProtocol);
                    }
                    if (inputTransport != null) {
                        inputTransport.close();
                    }
                    if (outputTransport != null) {
                        outputTransport.close();
                    }
                    if (this.client.isOpen()) {
                        this.client.close();
                    }
                }
                eventHandler.deleteContext(connectionContext, inputProtocol, outputProtocol);
            }
            if (inputTransport != null) {
                inputTransport.close();
            }
            if (outputTransport != null) {
                outputTransport.close();
            }
            if (!this.client.isOpen()) return;
            this.client.close();
            return;
        }
    }

    public static class Args
    extends TServer.AbstractServerArgs<Args> {
        private ExecutorService executorService;
        private ExecutorService startThreadPool;
        private CamelContext context;
        private int requestTimeout = 20;
        private TimeUnit requestTimeoutUnit = TimeUnit.SECONDS;
        private int beBackoffSlotLength = 100;
        private TimeUnit beBackoffSlotLengthUnit = TimeUnit.MILLISECONDS;

        public Args(TServerTransport transport) {
            super(transport);
        }

        public Args requestTimeout(int n) {
            this.requestTimeout = n;
            return this;
        }

        public Args requestTimeoutUnit(TimeUnit tu) {
            this.requestTimeoutUnit = tu;
            return this;
        }

        public Args beBackoffSlotLength(int n) {
            this.beBackoffSlotLength = n;
            return this;
        }

        public Args beBackoffSlotLengthUnit(TimeUnit tu) {
            this.beBackoffSlotLengthUnit = tu;
            return this;
        }

        public Args executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Args startThreadPool(ExecutorService startThreadPool) {
            this.startThreadPool = startThreadPool;
            return this;
        }

        public Args context(CamelContext context) {
            this.context = context;
            return this;
        }
    }
}

