/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.thrift.server;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import org.apache.camel.CamelContext;
import org.apache.camel.component.thrift.server.Invocation;
import org.apache.thrift.server.AbstractNonblockingServer;
import org.apache.thrift.server.TNonblockingServer;
import org.apache.thrift.transport.TNonblockingServerTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThriftHsHaServer
extends TNonblockingServer {
    private static final Logger LOG = LoggerFactory.getLogger(ThriftHsHaServer.class);
    private final ExecutorService invoker;
    private final CamelContext context;
    private final ExecutorService startExecutor;

    public ThriftHsHaServer(Args args) {
        super((AbstractNonblockingServer.AbstractNonblockingServerArgs)args);
        this.context = args.context;
        this.invoker = args.executorService;
        this.startExecutor = args.startThreadPool;
    }

    public void serve() throws IllegalArgumentException {
        if (!this.startThreads()) {
            throw new IllegalArgumentException("Failed to start selector thread!");
        }
        if (!this.startListening()) {
            throw new IllegalArgumentException("Failed to start listening on server socket!");
        }
        this.startExecutor.execute(() -> {
            this.setServing(true);
            this.waitForShutdown();
            this.setServing(false);
            this.stopListening();
        });
    }

    public void stop() {
        super.stop();
        this.context.getExecutorServiceManager().shutdownGraceful(this.startExecutor);
    }

    protected void waitForShutdown() {
        this.joinSelector();
        this.context.getExecutorServiceManager().shutdownGraceful(this.invoker);
    }

    protected boolean requestInvoke(AbstractNonblockingServer.FrameBuffer frameBuffer) {
        try {
            Runnable invocation = this.getRunnable(frameBuffer);
            this.invoker.execute(invocation);
            return true;
        }
        catch (RejectedExecutionException rx) {
            LOG.warn("ExecutorService rejected execution!", (Throwable)rx);
            return false;
        }
    }

    protected Runnable getRunnable(AbstractNonblockingServer.FrameBuffer frameBuffer) {
        return new Invocation(frameBuffer);
    }

    public static class Args
    extends AbstractNonblockingServer.AbstractNonblockingServerArgs<Args> {
        private ExecutorService executorService;
        private ExecutorService startThreadPool;
        private CamelContext context;

        public Args(TNonblockingServerTransport transport) {
            super(transport);
        }

        public Args executorService(ExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        public Args startThreadPool(ExecutorService startThreadPool) {
            this.startThreadPool = startThreadPool;
            return this;
        }

        public Args context(CamelContext context) {
            this.context = context;
            return this;
        }
    }
}

