/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.reactor.engine;

import java.io.Closeable;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.camel.Exchange;
import org.apache.camel.component.reactive.streams.ReactiveStreamsBackpressureStrategy;
import org.apache.camel.component.reactive.streams.ReactiveStreamsDiscardedException;
import org.apache.camel.component.reactive.streams.ReactiveStreamsHelper;
import org.apache.camel.component.reactive.streams.ReactiveStreamsProducer;
import org.apache.camel.component.reactor.engine.ReactorStreamsService;
import org.apache.camel.util.ObjectHelper;
import org.reactivestreams.Publisher;
import reactor.core.publisher.EmitterProcessor;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import reactor.core.publisher.SynchronousSink;
import reactor.util.concurrent.QueueSupplier;

final class ReactorCamelProcessor
implements Closeable {
    private final String name;
    private final EmitterProcessor<Exchange> publisher;
    private final AtomicReference<FluxSink<Exchange>> camelSink;
    private final ReactorStreamsService service;
    private ReactiveStreamsProducer camelProducer;

    ReactorCamelProcessor(ReactorStreamsService service, String name) {
        this.service = service;
        this.name = name;
        this.camelProducer = null;
        this.camelSink = new AtomicReference();
        this.publisher = EmitterProcessor.create((int)1, (boolean)false);
    }

    @Override
    public void close() throws IOException {
    }

    Publisher<Exchange> getPublisher() {
        return this.publisher;
    }

    synchronized void attach(ReactiveStreamsProducer producer) {
        Objects.requireNonNull(producer, "producer cannot be null, use the detach method");
        if (this.camelProducer != null) {
            throw new IllegalStateException("A producer is already attached to the stream '" + this.name + "'");
        }
        if (this.camelProducer != producer) {
            this.detach();
            ReactiveStreamsBackpressureStrategy strategy = producer.getEndpoint().getBackpressureStrategy();
            Flux flux = Flux.create(this.camelSink::set, (FluxSink.OverflowStrategy)FluxSink.OverflowStrategy.IGNORE);
            flux = ObjectHelper.equal((Object)strategy, (Object)ReactiveStreamsBackpressureStrategy.OLDEST) ? flux.onBackpressureDrop(this::onBackPressure).handle(this::onItemEmitted) : (ObjectHelper.equal((Object)strategy, (Object)ReactiveStreamsBackpressureStrategy.LATEST) ? flux.handle(this::onItemEmitted).onBackpressureLatest() : flux.onBackpressureBuffer(QueueSupplier.SMALL_BUFFER_SIZE, this::onBackPressure).handle(this::onItemEmitted));
            flux.subscribe(this.publisher);
            this.camelProducer = producer;
        }
    }

    synchronized void detach() {
        this.camelProducer = null;
        this.camelSink.set(null);
    }

    void send(Exchange exchange) {
        if (this.service.isRunAllowed()) {
            FluxSink sink = (FluxSink)ObjectHelper.notNull(this.camelSink.get(), (String)"FluxSink");
            sink.next((Object)exchange);
        }
    }

    private void onItemEmitted(Exchange exchange, SynchronousSink<Exchange> sink) {
        if (this.service.isRunAllowed()) {
            sink.next((Object)exchange);
            ReactiveStreamsHelper.invokeDispatchCallback((Exchange)exchange);
        }
    }

    private void onBackPressure(Exchange exchange) {
        ReactiveStreamsHelper.invokeDispatchCallback((Exchange)exchange, (Throwable)new ReactiveStreamsDiscardedException("Discarded by back pressure strategy", exchange, this.name));
    }
}

