/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp.impl;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.apache.camel.component.mllp.MllpAcknowledgementDeliveryException;
import org.apache.camel.component.mllp.MllpException;
import org.apache.camel.component.mllp.MllpWriteException;
import org.apache.camel.component.mllp.impl.MllpSocketWriter;

public class MllpBufferedSocketWriter
extends MllpSocketWriter {
    static final int DEFAULT_SO_SNDBUF = 65535;
    ByteArrayOutputStream outputBuffer;

    public MllpBufferedSocketWriter(Socket socket, boolean acknowledgementWriter) {
        super(socket, acknowledgementWriter);
        try {
            this.outputBuffer = new ByteArrayOutputStream(socket.getSendBufferSize());
        }
        catch (SocketException socketEx) {
            this.log.warn(String.format("Ignoring exception encountered retrieving SO_SNDBUF from the socket - using default size of %d bytes", 65535), (Throwable)socketEx);
            this.outputBuffer = new ByteArrayOutputStream(65535);
        }
    }

    @Override
    public void writeEnvelopedPayload(byte[] hl7MessageBytes, byte[] hl7AcknowledgementBytes) throws MllpException {
        if (this.socket == null) {
            String errorMessage = "Socket is null";
            if (this.isAcknowledgementWriter()) {
                throw new MllpAcknowledgementDeliveryException("Socket is null", hl7MessageBytes, hl7AcknowledgementBytes);
            }
            throw new MllpWriteException("Socket is null", hl7MessageBytes);
        }
        if (!this.socket.isConnected()) {
            String errorMessage = "Socket is not connected";
            if (this.isAcknowledgementWriter()) {
                throw new MllpAcknowledgementDeliveryException("Socket is not connected", hl7MessageBytes, hl7AcknowledgementBytes);
            }
            throw new MllpWriteException("Socket is not connected", hl7MessageBytes);
        }
        if (this.socket.isClosed()) {
            String errorMessage = "Socket is closed";
            if (this.isAcknowledgementWriter()) {
                throw new MllpAcknowledgementDeliveryException("Socket is closed", hl7MessageBytes, hl7AcknowledgementBytes);
            }
            throw new MllpWriteException("Socket is closed", hl7MessageBytes);
        }
        OutputStream socketOutputStream = null;
        try {
            socketOutputStream = this.socket.getOutputStream();
        }
        catch (IOException e) {
            String errorMessage = "Failed to retrieve the OutputStream from the Socket";
            if (this.isAcknowledgementWriter()) {
                throw new MllpAcknowledgementDeliveryException("Failed to retrieve the OutputStream from the Socket", hl7MessageBytes, hl7AcknowledgementBytes);
            }
            throw new MllpWriteException("Failed to retrieve the OutputStream from the Socket", hl7MessageBytes, hl7AcknowledgementBytes);
        }
        this.outputBuffer.write(11);
        if (this.isAcknowledgementWriter()) {
            if (hl7AcknowledgementBytes == null) {
                this.log.warn("HL7 Acknowledgement payload is null - sending empty MLLP payload");
            } else if (hl7AcknowledgementBytes.length <= 0) {
                this.log.warn("HL7 Acknowledgement payload is empty - sending empty MLLP payload");
            } else {
                this.outputBuffer.write(hl7AcknowledgementBytes, 0, hl7AcknowledgementBytes.length);
            }
        } else if (hl7MessageBytes == null) {
            this.log.warn("HL7 Message payload is null - sending empty MLLP payload");
        } else if (hl7MessageBytes.length <= 0) {
            this.log.warn("HL7 Message payload is empty - sending empty MLLP payload");
        } else {
            this.outputBuffer.write(hl7MessageBytes, 0, hl7MessageBytes.length);
        }
        this.outputBuffer.write(28);
        this.outputBuffer.write(13);
        try {
            this.outputBuffer.writeTo(socketOutputStream);
            socketOutputStream.flush();
        }
        catch (IOException e) {
            String errorMessage = "Failed to write the MLLP payload to the Socket's OutputStream";
            if (this.isAcknowledgementWriter()) {
                throw new MllpAcknowledgementDeliveryException("Failed to write the MLLP payload to the Socket's OutputStream", hl7MessageBytes, hl7AcknowledgementBytes);
            }
            throw new MllpWriteException("Failed to write the MLLP payload to the Socket's OutputStream", hl7MessageBytes);
        }
        finally {
            this.outputBuffer.reset();
        }
    }
}

