/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mllp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.api.management.ManagedOperation;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.component.mllp.MllpApplicationErrorAcknowledgementException;
import org.apache.camel.component.mllp.MllpApplicationRejectAcknowledgementException;
import org.apache.camel.component.mllp.MllpCommitErrorAcknowledgementException;
import org.apache.camel.component.mllp.MllpCommitRejectAcknowledgementException;
import org.apache.camel.component.mllp.MllpEndpoint;
import org.apache.camel.component.mllp.MllpException;
import org.apache.camel.component.mllp.MllpInvalidAcknowledgementException;
import org.apache.camel.component.mllp.MllpReceiveException;
import org.apache.camel.component.mllp.MllpWriteException;
import org.apache.camel.component.mllp.impl.Hl7Util;
import org.apache.camel.component.mllp.impl.MllpBufferedSocketWriter;
import org.apache.camel.component.mllp.impl.MllpSocketReader;
import org.apache.camel.component.mllp.impl.MllpSocketUtil;
import org.apache.camel.component.mllp.impl.MllpSocketWriter;
import org.apache.camel.impl.DefaultProducer;
import org.apache.camel.util.IOHelper;

@ManagedResource(description="MllpTcpClient Producer")
public class MllpTcpClientProducer
extends DefaultProducer {
    MllpEndpoint endpoint;
    Socket socket;
    MllpSocketReader mllpSocketReader;
    MllpSocketWriter mllpSocketWriter;

    public MllpTcpClientProducer(MllpEndpoint endpoint) throws SocketException {
        super((Endpoint)endpoint);
        this.log.trace("MllpTcpClientProducer(endpoint)");
        this.endpoint = endpoint;
    }

    protected void doStart() throws Exception {
        this.log.trace("doStart()");
        super.doStart();
    }

    protected void doStop() throws Exception {
        this.log.trace("doStop()");
        MllpSocketUtil.close(this.socket, this.log, "Stopping component");
        super.doStop();
    }

    @ManagedOperation(description="Close client socket")
    public void closeMllpSocket() {
        MllpSocketUtil.close(this.socket, this.log, "JMX triggered closing socket");
    }

    @ManagedOperation(description="Reset client socket")
    public void resetMllpSocket() {
        MllpSocketUtil.reset(this.socket, this.log, "JMX triggered resetting socket");
    }

    public void process(Exchange exchange) throws Exception {
        String exceptionMessage;
        this.log.trace("process(exchange)");
        if (((Boolean)exchange.getProperty("CamelMllpResetConnectionBeforeSend", Boolean.TYPE)).booleanValue()) {
            MllpSocketUtil.reset(this.socket, this.log, "Exchange property CamelMllpResetConnectionBeforeSend = " + exchange.getProperty("CamelMllpResetConnectionBeforeSend", Boolean.TYPE));
            return;
        }
        if (((Boolean)exchange.getProperty("CamelMllpCloseConnectionBeforeSend", Boolean.TYPE)).booleanValue()) {
            MllpSocketUtil.close(this.socket, this.log, "Exchange property CamelMllpCloseConnectionBeforeSend = " + exchange.getProperty("CamelMllpCloseConnectionBeforeSend", Boolean.TYPE));
            return;
        }
        try {
            this.checkConnection();
        }
        catch (IOException ioEx) {
            exchange.setException((Throwable)ioEx);
            return;
        }
        Message message = exchange.hasOut() ? exchange.getOut() : exchange.getIn();
        message.setHeader("CamelMllpLocalAddress", (Object)this.socket.getLocalAddress().toString());
        message.setHeader("CamelMllpRemoteAddress", (Object)this.socket.getRemoteSocketAddress().toString());
        byte[] hl7MessageBytes = (byte[])message.getMandatoryBody(byte[].class);
        byte[] acknowledgementBytes = null;
        try {
            this.log.debug("Sending message to external system");
            this.mllpSocketWriter.writeEnvelopedPayload(hl7MessageBytes, null);
            this.log.debug("Reading acknowledgement from external system");
            acknowledgementBytes = this.mllpSocketReader.readEnvelopedPayload(hl7MessageBytes);
        }
        catch (MllpWriteException writeEx) {
            MllpSocketUtil.reset(this.socket, this.log, writeEx.getMessage());
            exchange.setException((Throwable)writeEx);
            return;
        }
        catch (MllpReceiveException ackReceiveEx) {
            MllpSocketUtil.reset(this.socket, this.log, ackReceiveEx.getMessage());
            exchange.setException((Throwable)ackReceiveEx);
            return;
        }
        catch (MllpException mllpEx) {
            Throwable mllpExCause = mllpEx.getCause();
            if (mllpExCause != null && mllpExCause instanceof IOException) {
                MllpSocketUtil.reset(this.socket, this.log, mllpEx.getMessage());
            }
            exchange.setException((Throwable)mllpEx);
            return;
        }
        this.log.debug("Populating message headers with the acknowledgement from the external system");
        message.setHeader("CamelMllpAcknowledgement", (Object)acknowledgementBytes);
        message.setHeader("CamelMllpAcknowledgementString", (Object)new String(acknowledgementBytes, IOHelper.getCharsetName((Exchange)exchange, (boolean)true)));
        if (this.endpoint.validatePayload && (exceptionMessage = Hl7Util.generateInvalidPayloadExceptionMessage(acknowledgementBytes)) != null) {
            exchange.setException((Throwable)new MllpInvalidAcknowledgementException(exceptionMessage, hl7MessageBytes, acknowledgementBytes));
            return;
        }
        this.log.debug("Processing the acknowledgement from the external system");
        try {
            String acknowledgementType = this.processAcknowledgment(hl7MessageBytes, acknowledgementBytes);
            message.setHeader("CamelMllpAcknowledgementType", (Object)acknowledgementType);
        }
        catch (MllpException mllpEx) {
            exchange.setException((Throwable)mllpEx);
            return;
        }
        if (((Boolean)exchange.getProperty("CamelMllpResetConnectionAfterSend", Boolean.TYPE)).booleanValue()) {
            MllpSocketUtil.reset(this.socket, this.log, "Exchange property CamelMllpResetConnectionAfterSend = " + exchange.getProperty("CamelMllpResetConnectionAfterSend", Boolean.TYPE));
        } else if (((Boolean)exchange.getProperty("CamelMllpCloseConnectionAfterSend", Boolean.TYPE)).booleanValue()) {
            MllpSocketUtil.close(this.socket, this.log, "Exchange property CamelMllpCloseConnectionAfterSend = " + exchange.getProperty("CamelMllpCloseConnectionAfterSend", Boolean.TYPE));
        }
    }

    private String processAcknowledgment(byte[] hl7MessageBytes, byte[] hl7AcknowledgementBytes) throws MllpException {
        String acknowledgementType = "";
        if (hl7AcknowledgementBytes != null && hl7AcknowledgementBytes.length > 3) {
            byte fieldDelim = hl7AcknowledgementBytes[3];
            int msaStartIndex = -1;
            for (int i = 0; i < hl7AcknowledgementBytes.length; ++i) {
                if (13 != hl7AcknowledgementBytes[i]) continue;
                int bM = 77;
                int bS = 83;
                int bC = 67;
                int bA = 65;
                int bE = 69;
                int bR = 82;
                if (hl7AcknowledgementBytes.length <= i + 7 || 77 != hl7AcknowledgementBytes[i + 1] || 83 != hl7AcknowledgementBytes[i + 2] || 65 != hl7AcknowledgementBytes[i + 3] || fieldDelim != hl7AcknowledgementBytes[i + 4]) continue;
                msaStartIndex = i + 1;
                if (65 != hl7AcknowledgementBytes[i + 5] && 67 != hl7AcknowledgementBytes[i + 5]) {
                    String errorMessage = "Unsupported acknowledgement type: " + new String(hl7AcknowledgementBytes, i + 5, 2);
                    throw new MllpInvalidAcknowledgementException(errorMessage, hl7MessageBytes, hl7AcknowledgementBytes);
                }
                switch (hl7AcknowledgementBytes[i + 6]) {
                    case 65: {
                        if (65 == hl7AcknowledgementBytes[i + 5]) {
                            acknowledgementType = "AA";
                            break;
                        }
                        acknowledgementType = "CA";
                        break;
                    }
                    case 69: {
                        if (65 == hl7AcknowledgementBytes[i + 5]) {
                            throw new MllpApplicationErrorAcknowledgementException(hl7MessageBytes, hl7AcknowledgementBytes);
                        }
                        throw new MllpCommitErrorAcknowledgementException(hl7MessageBytes, hl7AcknowledgementBytes);
                    }
                    case 82: {
                        if (65 == hl7AcknowledgementBytes[i + 5]) {
                            throw new MllpApplicationRejectAcknowledgementException(hl7MessageBytes, hl7AcknowledgementBytes);
                        }
                        throw new MllpCommitRejectAcknowledgementException(hl7MessageBytes, hl7AcknowledgementBytes);
                    }
                    default: {
                        String errorMessage = "Unsupported acknowledgement type: " + new String(hl7AcknowledgementBytes, i + 5, 2);
                        throw new MllpInvalidAcknowledgementException(errorMessage, hl7MessageBytes, hl7AcknowledgementBytes);
                    }
                }
                break;
            }
            if (-1 == msaStartIndex && this.endpoint.validatePayload) {
                throw new MllpInvalidAcknowledgementException("MSA Not found in acknowledgement", hl7MessageBytes, hl7AcknowledgementBytes);
            }
        }
        return acknowledgementType;
    }

    private void checkConnection() throws IOException {
        if (null == this.socket || this.socket.isClosed() || !this.socket.isConnected()) {
            this.socket = new Socket();
            this.socket.setKeepAlive(this.endpoint.keepAlive);
            this.socket.setTcpNoDelay(this.endpoint.tcpNoDelay);
            if (null != this.endpoint.receiveBufferSize) {
                this.socket.setReceiveBufferSize(this.endpoint.receiveBufferSize);
            } else {
                this.endpoint.receiveBufferSize = this.socket.getReceiveBufferSize();
            }
            if (null != this.endpoint.sendBufferSize) {
                this.socket.setSendBufferSize(this.endpoint.sendBufferSize);
            } else {
                this.endpoint.sendBufferSize = this.socket.getSendBufferSize();
            }
            this.socket.setReuseAddress(this.endpoint.reuseAddress);
            this.socket.setSoLinger(false, -1);
            InetSocketAddress socketAddress = null == this.endpoint.getHostname() ? new InetSocketAddress(this.endpoint.getPort()) : new InetSocketAddress(this.endpoint.getHostname(), this.endpoint.getPort());
            this.log.debug("Connecting to socket on {}", (Object)socketAddress);
            this.socket.connect(socketAddress, this.endpoint.connectTimeout);
            this.log.debug("Creating MllpSocketReader and MllpSocketWriter");
            this.mllpSocketReader = new MllpSocketReader(this.socket, this.endpoint.receiveTimeout, this.endpoint.readTimeout, true);
            this.mllpSocketWriter = this.endpoint.bufferWrites ? new MllpBufferedSocketWriter(this.socket, false) : new MllpSocketWriter(this.socket, false);
        }
    }

    @ManagedOperation(description="Check client connection")
    public boolean managedCheckConnection() {
        boolean isValid = true;
        try {
            this.checkConnection();
        }
        catch (IOException ioEx) {
            isValid = false;
            this.log.debug("JMX check connection: {}", (Throwable)ioEx);
        }
        return isValid;
    }
}

