/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.irc;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.irc.IrcChannel;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.URISupport;
import org.apache.camel.util.UnsafeUriCharactersEncoder;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.schwering.irc.lib.ssl.SSLDefaultTrustManager;
import org.schwering.irc.lib.ssl.SSLTrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriParams
public class IrcConfiguration
implements Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(IrcConfiguration.class);
    private boolean usingSSL;
    private List<IrcChannel> channels = new ArrayList<IrcChannel>();
    @UriPath
    @Metadata(required="true")
    private String hostname;
    @UriPath
    private int port;
    private int[] ports = new int[]{6667, 6668, 6669};
    @UriParam(label="security", secret=true)
    private String password;
    @UriParam
    private String nickname;
    @UriParam
    private String realname;
    @UriParam(label="security", secret=true)
    private String username;
    @UriParam(label="security")
    private SSLTrustManager trustManager = new SSLDefaultTrustManager();
    @UriParam(defaultValue="true")
    @Deprecated
    private boolean persistent = true;
    @UriParam(defaultValue="true", label="advanced")
    private boolean colors = true;
    @UriParam(defaultValue="true", label="filter")
    private boolean onNick = true;
    @UriParam(defaultValue="true", label="filter")
    private boolean onQuit = true;
    @UriParam(defaultValue="true", label="filter")
    private boolean onJoin = true;
    @UriParam(defaultValue="true", label="filter")
    private boolean onKick = true;
    @UriParam(defaultValue="true", label="filter")
    private boolean onMode = true;
    @UriParam(defaultValue="true", label="filter")
    private boolean onPart = true;
    @UriParam(label="filter")
    private boolean onReply;
    @UriParam(defaultValue="true", label="filter")
    private boolean onTopic = true;
    @UriParam(defaultValue="true", label="filter")
    private boolean onPrivmsg = true;
    @UriParam(defaultValue="true")
    private boolean autoRejoin = true;
    @UriParam
    private boolean namesOnJoin;
    @UriParam(label="security")
    private SSLContextParameters sslContextParameters;
    @UriParam(label="security", secret=true)
    private String nickPassword;

    public IrcConfiguration() {
    }

    public IrcConfiguration(String hostname, String nickname, String displayname, List<IrcChannel> channels) {
        this(hostname, null, null, nickname, displayname, channels);
    }

    public IrcConfiguration(String hostname, String username, String password, String nickname, String displayname, List<IrcChannel> channels) {
        this.channels = channels;
        this.hostname = hostname;
        this.username = username;
        this.password = password;
        this.nickname = nickname;
        this.realname = displayname;
    }

    public IrcConfiguration copy() {
        try {
            return (IrcConfiguration)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    public String getCacheKey() {
        return this.hostname + ":" + this.nickname;
    }

    public String getListOfChannels() {
        String retval = "";
        for (IrcChannel channel : this.channels) {
            retval = retval + (retval.isEmpty() ? "" : " ") + channel.getName();
        }
        return retval;
    }

    public void configure(String uriStr) throws URISyntaxException, UnsupportedEncodingException {
        if (uriStr.startsWith("ircs")) {
            this.setUsingSSL(true);
            if (!uriStr.startsWith("ircs://")) {
                uriStr = uriStr.replace("ircs:", "ircs://");
            }
        } else if (!uriStr.startsWith("irc://")) {
            uriStr = uriStr.replace("irc:", "irc://");
        }
        if (uriStr.contains("?")) {
            uriStr = ObjectHelper.before((String)uriStr, (String)"?");
        }
        URI uri = new URI(uriStr);
        String userInfo = uri.getUserInfo();
        String username = null;
        String password = null;
        if (userInfo != null) {
            int colonIndex = userInfo.indexOf(":");
            if (colonIndex != -1) {
                username = userInfo.substring(0, colonIndex);
                password = userInfo.substring(colonIndex + 1);
            } else {
                username = userInfo;
            }
        }
        if (uri.getPort() != -1) {
            this.setPorts(new int[]{uri.getPort()});
            this.setPort(uri.getPort());
        }
        this.setNickname(username);
        this.setUsername(username);
        this.setRealname(username);
        this.setPassword(password);
        this.setHostname(uri.getHost());
        String path = uri.getPath();
        if (path != null && !path.isEmpty()) {
            LOG.warn("Channel {} should not be specified in the URI path. Use an @channel query parameter instead.", (Object)path);
        }
    }

    public void setChannel(String channel) {
        this.channels.add(IrcConfiguration.createChannel(channel));
    }

    public void setChannel(List<String> channels) {
        for (String ci : channels) {
            this.channels.add(IrcConfiguration.createChannel(ci));
        }
    }

    public List<IrcChannel> getChannels() {
        return this.channels;
    }

    public IrcChannel findChannel(String name) {
        for (IrcChannel channel : this.channels) {
            if (!channel.getName().equals(name)) continue;
            return channel;
        }
        return null;
    }

    public void setTrustManager(SSLTrustManager trustManager) {
        this.trustManager = trustManager;
    }

    public SSLTrustManager getTrustManager() {
        return this.trustManager;
    }

    public boolean getUsingSSL() {
        return this.usingSSL;
    }

    private void setUsingSSL(boolean usingSSL) {
        this.usingSSL = usingSSL;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getNickname() {
        return this.nickname;
    }

    public void setNickname(String nickname) {
        this.nickname = nickname;
    }

    public String getRealname() {
        return this.realname;
    }

    public void setRealname(String realname) {
        this.realname = realname;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public int[] getPorts() {
        return this.ports;
    }

    public void setPorts(int[] ports) {
        this.ports = ports;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    @Deprecated
    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isColors() {
        return this.colors;
    }

    public void setColors(boolean colors) {
        this.colors = colors;
    }

    public boolean isOnNick() {
        return this.onNick;
    }

    public void setOnNick(boolean onNick) {
        this.onNick = onNick;
    }

    public boolean isOnQuit() {
        return this.onQuit;
    }

    public void setOnQuit(boolean onQuit) {
        this.onQuit = onQuit;
    }

    public boolean isOnJoin() {
        return this.onJoin;
    }

    public void setOnJoin(boolean onJoin) {
        this.onJoin = onJoin;
    }

    public boolean isOnKick() {
        return this.onKick;
    }

    public void setOnKick(boolean onKick) {
        this.onKick = onKick;
    }

    public boolean isOnMode() {
        return this.onMode;
    }

    public void setOnMode(boolean onMode) {
        this.onMode = onMode;
    }

    public boolean isOnPart() {
        return this.onPart;
    }

    public void setOnPart(boolean onPart) {
        this.onPart = onPart;
    }

    public boolean isOnReply() {
        return this.onReply;
    }

    public void setOnReply(boolean onReply) {
        this.onReply = onReply;
    }

    public boolean isOnTopic() {
        return this.onTopic;
    }

    public void setOnTopic(boolean onTopic) {
        this.onTopic = onTopic;
    }

    public boolean isOnPrivmsg() {
        return this.onPrivmsg;
    }

    public void setOnPrivmsg(boolean onPrivmsg) {
        this.onPrivmsg = onPrivmsg;
    }

    public boolean isAutoRejoin() {
        return this.autoRejoin;
    }

    public void setAutoRejoin(boolean autoRejoin) {
        this.autoRejoin = autoRejoin;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }

    public String getNickPassword() {
        return this.nickPassword;
    }

    public void setNickPassword(String nickPassword) {
        this.nickPassword = nickPassword;
    }

    public boolean isNamesOnJoin() {
        return this.namesOnJoin;
    }

    public void setNamesOnJoin(boolean namesOnJoin) {
        this.namesOnJoin = namesOnJoin;
    }

    public String toString() {
        return "IrcConfiguration[hostname: " + this.hostname + ", ports=" + Arrays.toString(this.ports) + ", username=" + this.username + "]";
    }

    private static IrcChannel createChannel(String channelInfo) {
        String[] pair = channelInfo.split("!");
        return new IrcChannel(pair[0], pair.length > 1 ? pair[1] : null);
    }

    @Deprecated
    public static String sanitize(String uri) {
        int colon = uri.indexOf(58);
        if (colon != -1 && uri.indexOf("://") != colon) {
            uri = uri.substring(0, colon) + "://" + uri.substring(colon + 1);
        }
        try {
            URI u = new URI(UnsafeUriCharactersEncoder.encode((String)uri));
            String[] userInfo = u.getUserInfo() != null ? u.getUserInfo().split(":") : null;
            String username = userInfo != null ? userInfo[0] : null;
            String password = userInfo != null && userInfo.length > 1 ? userInfo[1] : null;
            String path = URLDecoder.decode(u.getPath() != null ? u.getPath() : "", "UTF-8");
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if (path.startsWith("#") && !path.startsWith("##")) {
                path = path.substring(1);
            }
            Map parameters = URISupport.parseParameters((URI)u);
            String user = (String)parameters.get("username");
            String nick = (String)parameters.get("nickname");
            if (user != null) {
                if (username == null) {
                    username = user;
                } else if (!username.equals(user)) {
                    LOG.warn("Username specified twice in endpoint URI with different values. The userInfo value ('{}') will be used, paramter ('{}') ignored", (Object)username, (Object)user);
                }
                parameters.remove("username");
            }
            if (nick != null) {
                if (username == null) {
                    username = nick;
                }
                if (username.equals(nick)) {
                    parameters.remove("nickname");
                }
            }
            if (username == null) {
                throw new RuntimeCamelException("IrcEndpoint URI with no user/nick specified is invalid");
            }
            String pwd = (String)parameters.get("password");
            if (pwd != null) {
                password = pwd;
                parameters.remove("password");
            }
            ArrayList<String> cl = new ArrayList<String>();
            String channels = (String)parameters.get("channels");
            String keys = (String)parameters.get("keys");
            String string = keys = keys == null ? keys : keys + " ";
            if (channels != null) {
                String[] chs = channels.split(",");
                String[] ks = keys != null ? keys.split(",") : null;
                parameters.remove("channels");
                int count = chs.length;
                if (ks != null) {
                    parameters.remove("keys");
                    if (!path.isEmpty()) {
                        LOG.warn("Specifying a channel '{}' in the URI path is ambiguous when @channels and @keys are provided and will be ignored", (Object)path);
                        path = "";
                    }
                    if (ks.length != chs.length) {
                        count = count < ks.length ? count : ks.length;
                        LOG.warn("Different count of @channels and @keys. Only the first {} are used.", (Object)count);
                    }
                }
                for (int i = 0; i < count; ++i) {
                    String key;
                    String channel = chs[i].trim();
                    String string2 = key = ks != null ? ks[i].trim() : null;
                    if (channel.startsWith("#") && !channel.startsWith("##")) {
                        channel = channel.substring(1);
                    }
                    if (key != null && !key.isEmpty()) {
                        channel = channel + "!" + key;
                    }
                    cl.add(channel);
                }
            } else {
                if (path.isEmpty()) {
                    LOG.warn("No channel specified for the irc endpoint");
                }
                cl.add(path);
            }
            parameters.put("channel", cl);
            StringBuilder sb = new StringBuilder();
            sb.append(u.getScheme());
            sb.append("://");
            sb.append(username);
            sb.append(password == null ? "" : ":" + password);
            sb.append("@");
            sb.append(u.getHost());
            sb.append(u.getPort() == -1 ? "" : ":" + u.getPort());
            String query = IrcConfiguration.formatQuery(parameters);
            if (!query.isEmpty()) {
                sb.append("?");
                sb.append(query);
            }
            return sb.toString();
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    private static String formatQuery(Map<String, Object> params) {
        if (params == null || params.size() == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (Map.Entry<String, Object> pair : params.entrySet()) {
            Object value = pair.getValue();
            if (value instanceof List) {
                List list = (List)value;
                for (Object s : list) {
                    IrcConfiguration.addQueryParameter(result, pair.getKey(), s);
                }
                continue;
            }
            IrcConfiguration.addQueryParameter(result, pair.getKey(), value);
        }
        return result.toString();
    }

    private static void addQueryParameter(StringBuilder sb, String key, Object value) {
        sb.append(sb.length() == 0 ? "" : "&");
        sb.append(key);
        if (value != null) {
            String s = value.toString();
            sb.append(s.isEmpty() ? "" : "=" + UnsafeUriCharactersEncoder.encode((String)s));
        }
    }
}

