/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.firehose;

import com.amazonaws.services.kinesisfirehose.AmazonKinesisFirehose;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.firehose.KinesisFirehoseComponent;
import org.apache.camel.component.aws.firehose.KinesisFirehoseProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(firstVersion="2.19.0", scheme="aws-kinesis-firehose", title="AWS Kinesis Firehose", syntax="aws-kinesis-firehose:streamName", producerOnly=true, label="cloud,messaging")
public class KinesisFirehoseEndpoint
extends DefaultEndpoint {
    @UriPath(description="Name of the stream")
    @Metadata(required="true")
    private String streamName;
    @UriParam(description="Amazon Kinesis Firehose client to use for all requests for this endpoint")
    @Metadata(required="true")
    private AmazonKinesisFirehose amazonKinesisFirehoseClient;

    public KinesisFirehoseEndpoint(String uri, String streamName, KinesisFirehoseComponent component) {
        super(uri, (Component)component);
        this.streamName = streamName;
    }

    public Producer createProducer() throws Exception {
        return new KinesisFirehoseProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        throw new UnsupportedOperationException("You cannot consume messages from this endpoint");
    }

    public boolean isSingleton() {
        return true;
    }

    public void setAmazonKinesisFirehoseClient(AmazonKinesisFirehose client) {
        this.amazonKinesisFirehoseClient = client;
    }

    public AmazonKinesisFirehose getClient() {
        return this.amazonKinesisFirehoseClient;
    }

    public String getStreamName() {
        return this.streamName;
    }
}

