/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cache;

import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.event.CacheEventListener;
import net.sf.ehcache.loader.CacheLoader;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.cache.CacheConfiguration;
import org.apache.camel.component.cache.CacheConsumer;
import org.apache.camel.component.cache.CacheLoaderWrapper;
import org.apache.camel.component.cache.CacheManagerFactory;
import org.apache.camel.component.cache.CacheProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="2.1.0", scheme="cache", title="EHCache", syntax="cache:cacheName", consumerClass=CacheConsumer.class, label="cache")
public class CacheEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(CacheEndpoint.class);
    @UriParam
    private CacheConfiguration config;
    @UriParam(label="advanced")
    private CacheManagerFactory cacheManagerFactory;
    @UriParam
    private String key;
    @UriParam
    private String operation;

    public CacheEndpoint() {
    }

    public CacheEndpoint(String endpointUri, Component component, CacheConfiguration config, CacheManagerFactory cacheManagerFactory) {
        super(endpointUri, component);
        this.config = config;
        this.cacheManagerFactory = cacheManagerFactory;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        ObjectHelper.notNull((Object)this.config, (String)"config");
        ObjectHelper.notNull((Object)((Object)this.cacheManagerFactory), (String)"cacheManagerFactory");
        CacheConsumer answer = new CacheConsumer((Endpoint)this, processor, this.config);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public Producer createProducer() throws Exception {
        ObjectHelper.notNull((Object)this.config, (String)"config");
        ObjectHelper.notNull((Object)((Object)this.cacheManagerFactory), (String)"cacheManagerFactory");
        return new CacheProducer(this, this.config);
    }

    public boolean isSingleton() {
        return true;
    }

    public CacheConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(CacheConfiguration config) {
        this.config = config;
    }

    public CacheManagerFactory getCacheManagerFactory() {
        return this.cacheManagerFactory;
    }

    public void setCacheManagerFactory(CacheManagerFactory cacheManagerFactory) {
        this.cacheManagerFactory = cacheManagerFactory;
    }

    public Exchange createCacheExchange(String operation, String key, Object value) {
        Exchange exchange = super.createExchange();
        Message message = exchange.getIn();
        message.setHeader("CamelCacheOperation", (Object)operation);
        message.setHeader("CamelCacheKey", (Object)key);
        message.setBody(value);
        return exchange;
    }

    public Ehcache initializeCache() {
        Ehcache cache;
        CacheManager cacheManager = this.getCacheManagerFactory().getInstance();
        if (cacheManager.cacheExists(this.config.getCacheName())) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Found an existing cache: {}", (Object)this.config.getCacheName());
                LOG.trace("Cache {} currently contains {} elements", (Object)this.config.getCacheName(), (Object)cacheManager.getEhcache(this.config.getCacheName()).getSize());
            }
            cache = cacheManager.getEhcache(this.config.getCacheName());
        } else {
            cache = new Cache(this.config.getCacheName(), this.config.getMaxElementsInMemory(), this.config.getMemoryStoreEvictionPolicy(), this.config.isOverflowToDisk(), this.config.getDiskStorePath(), this.config.isEternal(), this.config.getTimeToLiveSeconds(), this.config.getTimeToIdleSeconds(), this.config.isDiskPersistent(), this.config.getDiskExpiryThreadIntervalSeconds(), null);
            for (CacheEventListener listener : this.config.getEventListenerRegistry().getEventListeners()) {
                cache.getCacheEventNotificationService().registerListener(listener);
            }
            for (CacheLoaderWrapper loader : this.config.getCacheLoaderRegistry().getCacheLoaders()) {
                loader.init(cache);
                cache.registerCacheLoader((CacheLoader)loader);
            }
            cacheManager.addCache(cache);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Added a new cache: " + cache.getName());
            }
        }
        return cache;
    }

    public void stop() {
        CacheManager cacheManager = this.getCacheManagerFactory().getInstance();
        cacheManager.removeCache(this.config.getCacheName());
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }
}

