/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul.ha;

import org.apache.camel.component.consul.ha.ConsulClusterConfiguration;
import org.apache.camel.component.consul.ha.ConsulClusterView;
import org.apache.camel.impl.ha.AbstractCamelClusterService;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConsulClusterService
extends AbstractCamelClusterService<ConsulClusterView> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsulClusterService.class);
    private ConsulClusterConfiguration configuration;

    public ConsulClusterService() {
        this.configuration = new ConsulClusterConfiguration();
    }

    public ConsulClusterService(ConsulClusterConfiguration configuration) {
        this.configuration = configuration.copy();
    }

    public ConsulClusterConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ConsulClusterConfiguration configuration) {
        this.configuration = configuration.copy();
    }

    public String getUrl() {
        return this.configuration.getUrl();
    }

    public void setUrl(String url) {
        this.configuration.setUrl(url);
    }

    public String getDatacenter() {
        return this.configuration.getDatacenter();
    }

    public void setDatacenter(String datacenter) {
        this.configuration.setDatacenter(datacenter);
    }

    public SSLContextParameters getSslContextParameters() {
        return this.configuration.getSslContextParameters();
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.configuration.setSslContextParameters(sslContextParameters);
    }

    public String getAclToken() {
        return this.configuration.getAclToken();
    }

    public void setAclToken(String aclToken) {
        this.configuration.setAclToken(aclToken);
    }

    public String getUserName() {
        return this.configuration.getUserName();
    }

    public void setUserName(String userName) {
        this.configuration.setUserName(userName);
    }

    public String getPassword() {
        return this.configuration.getPassword();
    }

    public void setPassword(String password) {
        this.configuration.setPassword(password);
    }

    public Long getConnectTimeoutMillis() {
        return this.configuration.getConnectTimeoutMillis();
    }

    public void setConnectTimeoutMillis(Long connectTimeoutMillis) {
        this.configuration.setConnectTimeoutMillis(connectTimeoutMillis);
    }

    public Long getReadTimeoutMillis() {
        return this.configuration.getReadTimeoutMillis();
    }

    public void setReadTimeoutMillis(Long readTimeoutMillis) {
        this.configuration.setReadTimeoutMillis(readTimeoutMillis);
    }

    public Long getWriteTimeoutMillis() {
        return this.configuration.getWriteTimeoutMillis();
    }

    public void setWriteTimeoutMillis(Long writeTimeoutMillis) {
        this.configuration.setWriteTimeoutMillis(writeTimeoutMillis);
    }

    public Integer getBlockSeconds() {
        return this.configuration.getBlockSeconds();
    }

    public void setBlockSeconds(Integer blockSeconds) {
        this.configuration.setBlockSeconds(blockSeconds);
    }

    public int getTtl() {
        return this.configuration.getSessionTtl();
    }

    public void setTtl(int ttl) {
        this.configuration.setSessionTtl(ttl);
    }

    public int getLockDelay() {
        return this.configuration.getSessionLockDelay();
    }

    public void setLockDelay(int lockDelay) {
        this.configuration.setSessionLockDelay(lockDelay);
    }

    public String getRootPath() {
        return this.configuration.getRootPath();
    }

    public void setRootPath(String rootPath) {
        this.configuration.setRootPath(rootPath);
    }

    protected ConsulClusterView createView(String namespace) throws Exception {
        ObjectHelper.notNull((Object)this.getCamelContext(), (String)"Camel Context");
        ObjectHelper.notNull((Object)this.getRootPath(), (String)"Consul root path");
        return new ConsulClusterView(this, this.configuration, namespace);
    }
}

