/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.ribbon.cloud;

import com.netflix.loadbalancer.Server;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.camel.cloud.ServiceDefinition;
import org.apache.camel.cloud.ServiceHealth;
import org.apache.camel.impl.cloud.DefaultServiceHealth;
import org.apache.camel.util.ObjectHelper;

public class RibbonServiceDefinition
extends Server
implements ServiceDefinition {
    private static final ServiceHealth DEFAULT_SERVICE_HEALTH = new DefaultServiceHealth();
    private String name;
    private ServiceHealth health;
    private Map<String, String> metaData;

    public RibbonServiceDefinition(String name, String host, int port) {
        this(name, host, port, null, DEFAULT_SERVICE_HEALTH);
    }

    public RibbonServiceDefinition(String name, String host, int port, ServiceHealth healt) {
        this(name, host, port, null, healt);
    }

    public RibbonServiceDefinition(String name, String host, int port, Map<String, String> meta) {
        this(name, host, port, meta, DEFAULT_SERVICE_HEALTH);
    }

    public RibbonServiceDefinition(String name, String host, int port, Map<String, String> meta, ServiceHealth healt) {
        super(host, port);
        this.name = name;
        this.metaData = meta;
        this.health = healt;
    }

    public RibbonServiceDefinition(ServiceDefinition definition) {
        this(definition.getName(), definition.getHost(), definition.getPort(), definition.getMetadata(), definition.getHealth());
    }

    public String getName() {
        return this.name;
    }

    public String getHost() {
        return super.getHost();
    }

    public int getPort() {
        return super.getPort();
    }

    public ServiceHealth getHealth() {
        return this.health;
    }

    public Map<String, String> getMetadata() {
        HashMap<String, String> meta = this.metaData != null ? new HashMap<String, String>(this.metaData) : new HashMap();
        ObjectHelper.ifNotEmpty((Object)super.getId(), val -> meta.put("id", (String)val));
        ObjectHelper.ifNotEmpty((Object)super.getZone(), val -> meta.put("zone", (String)val));
        ObjectHelper.ifNotEmpty((Object)super.isAlive(), val -> meta.put("is_alive", Boolean.toString(val)));
        ObjectHelper.ifNotEmpty((Object)super.isReadyToServe(), val -> meta.put("ready_to_server", Boolean.toString(val)));
        return Collections.unmodifiableMap(meta);
    }
}

