/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul.health;

import com.orbitz.consul.Consul;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.component.consul.health.ConsulHealthCheckRepositoryConfiguration;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.health.HealthCheckConfiguration;
import org.apache.camel.health.HealthCheckRepository;
import org.apache.camel.health.HealthCheckResultBuilder;
import org.apache.camel.impl.health.AbstractHealthCheck;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.function.Suppliers;

public class ConsulHealthCheckRepository
implements HealthCheckRepository,
CamelContextAware {
    private final Supplier<Consul> client;
    private final ConcurrentMap<String, HealthCheck> checks = new ConcurrentHashMap<String, HealthCheck>();
    private ConsulHealthCheckRepositoryConfiguration configuration;
    private CamelContext camelContext;

    public ConsulHealthCheckRepository() {
        this(null);
    }

    private ConsulHealthCheckRepository(ConsulHealthCheckRepositoryConfiguration configuration) {
        this.configuration = configuration;
        this.client = Suppliers.memorize(this::createConsul, ObjectHelper::wrapRuntimeCamelException);
    }

    public ConsulHealthCheckRepositoryConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(ConsulHealthCheckRepositoryConfiguration configuration) {
        this.configuration = configuration;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public Stream<HealthCheck> stream() {
        Set<String> ids = this.configuration.getChecks();
        if (ObjectHelper.isNotEmpty(ids)) {
            return ids.stream().map(checkId -> this.checks.computeIfAbsent((String)checkId, x$0 -> new ConsulHealthCheck((String)x$0))).filter(check -> check.getConfiguration().isEnabled());
        }
        return Stream.empty();
    }

    private Consul createConsul() throws Exception {
        ConsulHealthCheckRepositoryConfiguration conf = this.configuration;
        if (conf == null) {
            conf = new ConsulHealthCheckRepositoryConfiguration();
        }
        return conf.createConsulClient(this.camelContext);
    }

    public static final class Builder
    implements org.apache.camel.Builder<ConsulHealthCheckRepository> {
        private HealthCheckConfiguration defaultConfiguration;
        private Set<String> checks;
        private Map<String, HealthCheckConfiguration> configurations;

        public Builder configuration(HealthCheckConfiguration defaultConfiguration) {
            this.defaultConfiguration = defaultConfiguration;
            return this;
        }

        public Builder configuration(String id, HealthCheckConfiguration configuration) {
            if (this.configurations == null) {
                this.configurations = new HashMap<String, HealthCheckConfiguration>();
            }
            this.configurations.put(id, configuration);
            return this;
        }

        public Builder configurations(Map<String, HealthCheckConfiguration> configurations) {
            if (ObjectHelper.isNotEmpty(configurations)) {
                configurations.forEach(this::configuration);
            }
            return this;
        }

        public Builder check(String id) {
            if (ObjectHelper.isNotEmpty((Object)id)) {
                if (this.checks == null) {
                    this.checks = new HashSet<String>();
                }
                this.checks.add(id);
            }
            return this;
        }

        public Builder checks(Collection<String> ids) {
            if (ObjectHelper.isNotEmpty(ids)) {
                ids.forEach(this::check);
            }
            return this;
        }

        public ConsulHealthCheckRepository build() {
            ConsulHealthCheckRepositoryConfiguration configuration = new ConsulHealthCheckRepositoryConfiguration();
            configuration.setDefaultConfiguration(this.defaultConfiguration);
            if (this.checks != null) {
                this.checks.forEach(configuration::addCheck);
            }
            if (this.configurations != null) {
                this.configurations.forEach(configuration::addConfiguration);
            }
            return new ConsulHealthCheckRepository(configuration);
        }
    }

    private class ConsulHealthCheck
    extends AbstractHealthCheck {
        private final String checkId;

        ConsulHealthCheck(String checkId) {
            super("consul-" + checkId.replaceAll(":", "-"));
            this.checkId = checkId;
            HealthCheckConfiguration conf = ConsulHealthCheckRepository.this.configuration.getConfigurations().get(this.getId());
            if (conf == null) {
                conf = HealthCheckConfiguration.builder().complete(ConsulHealthCheckRepository.this.configuration.getDefaultConfiguration()).build();
            }
            this.setConfiguration(conf);
        }

        protected void doCall(HealthCheckResultBuilder builder, Map<String, Object> options) {
            builder.unknown();
            com.orbitz.consul.model.health.HealthCheck check = (com.orbitz.consul.model.health.HealthCheck)((Consul)ConsulHealthCheckRepository.this.client.get()).agentClient().getChecks().get(this.checkId);
            if (check != null) {
                if (ObjectHelper.equalIgnoreCase((Object)check.getStatus(), (Object)"passing")) {
                    builder.up();
                }
                if (ObjectHelper.equalIgnoreCase((Object)check.getStatus(), (Object)"warning")) {
                    builder.down();
                }
                if (ObjectHelper.equalIgnoreCase((Object)check.getStatus(), (Object)"critical")) {
                    builder.down();
                }
                builder.detail("consul.service.name", check.getServiceName().orNull());
                builder.detail("consul.service.id", check.getServiceId().orNull());
                builder.detail("consul.check.status", (Object)check.getStatus());
                builder.detail("consul.check.id", (Object)check.getCheckId());
            }
        }
    }
}

