/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.consul.ha;

import com.orbitz.consul.Consul;
import com.orbitz.consul.KeyValueClient;
import com.orbitz.consul.SessionClient;
import com.orbitz.consul.async.ConsulResponseCallback;
import com.orbitz.consul.model.ConsulResponse;
import com.orbitz.consul.model.kv.Value;
import com.orbitz.consul.model.session.ImmutableSession;
import com.orbitz.consul.model.session.Session;
import com.orbitz.consul.model.session.SessionInfo;
import com.orbitz.consul.option.QueryOptions;
import java.math.BigInteger;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.camel.component.consul.ha.ConsulClusterConfiguration;
import org.apache.camel.component.consul.ha.ConsulClusterService;
import org.apache.camel.ha.CamelClusterMember;
import org.apache.camel.ha.CamelClusterService;
import org.apache.camel.impl.ha.AbstractCamelClusterView;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConsulClusterView
extends AbstractCamelClusterView {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsulClusterService.class);
    private final ConsulClusterConfiguration configuration;
    private final ConsulLocalMember localMember;
    private final AtomicReference<String> sessionId;
    private final Watcher watcher;
    private Consul client;
    private SessionClient sessionClient;
    private KeyValueClient keyValueClient;
    private String path;

    ConsulClusterView(ConsulClusterService service, ConsulClusterConfiguration configuration, String namespace) throws Exception {
        super((CamelClusterService)service, namespace);
        this.configuration = configuration;
        this.localMember = new ConsulLocalMember();
        this.sessionId = new AtomicReference();
        this.watcher = new Watcher();
        this.path = configuration.getRootPath() + "/" + namespace;
    }

    public Optional<CamelClusterMember> getMaster() {
        if (this.keyValueClient == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.keyValueClient.getSession(this.configuration.getRootPath()).transform(x$0 -> new ConsulClusterMember((String)x$0)).orNull());
    }

    public CamelClusterMember getLocalMember() {
        return this.localMember;
    }

    public List<CamelClusterMember> getMembers() {
        if (this.sessionClient == null) {
            return Collections.emptyList();
        }
        return this.sessionClient.listSessions().stream().filter(i -> i.getName().equals((Object)this.getNamespace())).map(x$0 -> new ConsulClusterMember((SessionInfo)x$0)).collect(Collectors.toList());
    }

    protected void doStart() throws Exception {
        if (this.sessionId.get() == null) {
            this.client = this.configuration.createConsulClient(this.getCamelContext());
            this.sessionClient = this.client.sessionClient();
            this.keyValueClient = this.client.keyValueClient();
            this.sessionId.set(this.sessionClient.createSession((Session)ImmutableSession.builder().name(this.getNamespace()).ttl(this.configuration.getSessionTtl() + "s").lockDelay(this.configuration.getSessionLockDelay() + "s").build()).getId());
            LOGGER.debug("Acquired session with id '{}'", (Object)this.sessionId.get());
            boolean lock = this.acquireLock();
            LOGGER.debug("Acquire lock on path '{}' with id '{}' result '{}'", new Object[]{this.path, this.sessionId.get(), lock});
            this.localMember.setMaster(lock);
            this.watcher.watch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Exception {
        if (this.sessionId.get() != null) {
            if (this.keyValueClient.releaseLock(this.path, this.sessionId.get())) {
                LOGGER.debug("Successfully released lock on path '{}' with id '{}'", (Object)this.path, (Object)this.sessionId.get());
            }
            AtomicReference<String> atomicReference = this.sessionId;
            synchronized (atomicReference) {
                this.sessionClient.destroySession((String)this.sessionId.getAndSet(null));
                this.localMember.setMaster(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean acquireLock() {
        AtomicReference<String> atomicReference = this.sessionId;
        synchronized (atomicReference) {
            String sid = this.sessionId.get();
            return sid != null ? (Boolean)this.sessionClient.getSessionInfo(sid).transform(si -> this.keyValueClient.acquireLock(this.path, sid)).or((Object)Boolean.FALSE) : false;
        }
    }

    private class Watcher
    implements ConsulResponseCallback<com.google.common.base.Optional<Value>> {
        private final AtomicReference<BigInteger> index = new AtomicReference<BigInteger>(new BigInteger("0"));

        public void onComplete(ConsulResponse<com.google.common.base.Optional<Value>> consulResponse) {
            if (ConsulClusterView.this.isStarting() || ConsulClusterView.this.isStarted()) {
                com.google.common.base.Optional value = (com.google.common.base.Optional)consulResponse.getResponse();
                if (value.isPresent()) {
                    com.google.common.base.Optional sid = ((Value)value.get()).getSession();
                    if (!sid.isPresent()) {
                        boolean lock = ConsulClusterView.this.acquireLock();
                        LOGGER.debug("Try to acquire lock on path '{}' with id '{}', result '{}'", new Object[]{ConsulClusterView.this.path, ConsulClusterView.this.sessionId.get(), lock});
                        ConsulClusterView.this.localMember.setMaster(lock);
                    } else {
                        boolean master = ((String)sid.get()).equals(ConsulClusterView.this.sessionId.get());
                        if (!master) {
                            LOGGER.debug("Path {} is held by session {}, local session is {}", new Object[]{ConsulClusterView.this.path, sid.get(), ConsulClusterView.this.sessionId.get()});
                        }
                        ConsulClusterView.this.localMember.setMaster(((String)sid.get()).equals(ConsulClusterView.this.sessionId.get()));
                    }
                }
                this.index.set(consulResponse.getIndex());
                this.watch();
            }
        }

        public void onFailure(Throwable throwable) {
            LOGGER.debug("", throwable);
            if (ConsulClusterView.this.sessionId.get() != null) {
                ConsulClusterView.this.keyValueClient.releaseLock(ConsulClusterView.this.configuration.getRootPath(), (String)ConsulClusterView.this.sessionId.get());
            }
            ConsulClusterView.this.localMember.setMaster(false);
            this.watch();
        }

        public void watch() {
            if (ConsulClusterView.this.sessionId.get() == null) {
                return;
            }
            if (ConsulClusterView.this.isStarting() || ConsulClusterView.this.isStarted()) {
                ConsulClusterView.this.keyValueClient.getValue(ConsulClusterView.this.path, (QueryOptions)QueryOptions.blockSeconds((int)ConsulClusterView.this.configuration.getSessionRefreshInterval(), (BigInteger)this.index.get()).build(), (ConsulResponseCallback)this);
                if (ConsulClusterView.this.sessionId.get() != null) {
                    ConsulClusterView.this.sessionClient.renewSession((String)ConsulClusterView.this.sessionId.get());
                }
            }
        }
    }

    private final class ConsulClusterMember
    implements CamelClusterMember {
        private final String id;

        ConsulClusterMember() {
            this.id = null;
        }

        ConsulClusterMember(SessionInfo info) {
            this(info.getId());
        }

        ConsulClusterMember(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public boolean isLeader() {
            if (ConsulClusterView.this.keyValueClient == null) {
                return false;
            }
            if (this.id == null) {
                return false;
            }
            return this.id.equals(ConsulClusterView.this.keyValueClient.getSession(ConsulClusterView.this.path));
        }

        public boolean isLocal() {
            if (this.id == null) {
                return false;
            }
            return ObjectHelper.equal((Object)this.id, (Object)ConsulClusterView.this.localMember.getId());
        }

        public String toString() {
            return "ConsulClusterMember{id='" + this.id + '\'' + '}';
        }
    }

    private final class ConsulLocalMember
    implements CamelClusterMember {
        private AtomicBoolean master = new AtomicBoolean(false);

        private ConsulLocalMember() {
        }

        void setMaster(boolean master) {
            if (master && this.master.compareAndSet(false, true)) {
                LOGGER.debug("Leadership taken for session id {}", ConsulClusterView.this.sessionId.get());
                ConsulClusterView.this.fireLeadershipChangedEvent(Optional.of(this));
                return;
            }
            if (!master && this.master.compareAndSet(true, false)) {
                LOGGER.debug("Leadership lost for session id {}", ConsulClusterView.this.sessionId.get());
                ConsulClusterView.this.fireLeadershipChangedEvent(ConsulClusterView.this.getMaster());
                return;
            }
        }

        public boolean isLeader() {
            return this.master.get();
        }

        public boolean isLocal() {
            return true;
        }

        public String getId() {
            return (String)ConsulClusterView.this.sessionId.get();
        }

        public String toString() {
            return "ConsulLocalMember{master=" + this.master + '}';
        }
    }
}

