/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo;

import java.util.Base64;
import java.util.Objects;
import java.util.UUID;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;

public final class NodeIds {
    private NodeIds() {
    }

    public static String nodeValue(String namespace, String node) {
        Objects.requireNonNull(namespace);
        Objects.requireNonNull(node);
        StringBuilder builder = new StringBuilder("RAW(");
        NodeIds.appendNamespace(builder, namespace);
        builder.append(';');
        NodeIds.appendNodeId(builder, node);
        builder.append(')');
        return builder.toString();
    }

    public static String nodeValue(String namespace, int node) {
        Objects.requireNonNull(namespace);
        StringBuilder builder = new StringBuilder("RAW(");
        NodeIds.appendNamespace(builder, namespace);
        builder.append(';');
        NodeIds.appendNodeId(builder, node);
        builder.append(')');
        return builder.toString();
    }

    public static String nodeValue(String namespace, UUID node) {
        Objects.requireNonNull(namespace);
        Objects.requireNonNull(node);
        StringBuilder builder = new StringBuilder("RAW(");
        NodeIds.appendNamespace(builder, namespace);
        builder.append(';');
        NodeIds.appendNodeId(builder, node);
        builder.append(')');
        return builder.toString();
    }

    public static String nodeValue(String namespace, ByteString node) {
        Objects.requireNonNull(namespace);
        Objects.requireNonNull(node);
        StringBuilder builder = new StringBuilder("RAW(");
        NodeIds.appendNamespace(builder, namespace);
        builder.append(';');
        NodeIds.appendNodeId(builder, node);
        builder.append(')');
        return builder.toString();
    }

    public static String nodeValue(int namespace, String node) {
        Objects.requireNonNull(namespace);
        Objects.requireNonNull(node);
        StringBuilder builder = new StringBuilder("RAW(");
        NodeIds.appendNamespace(builder, namespace);
        builder.append(';');
        NodeIds.appendNodeId(builder, node);
        builder.append(')');
        return builder.toString();
    }

    public static String nodeValue(int namespace, int node) {
        Objects.requireNonNull(namespace);
        StringBuilder builder = new StringBuilder("RAW(");
        NodeIds.appendNamespace(builder, namespace);
        builder.append(';');
        NodeIds.appendNodeId(builder, node);
        builder.append(')');
        return builder.toString();
    }

    public static String nodeValue(int namespace, UUID node) {
        Objects.requireNonNull(namespace);
        Objects.requireNonNull(node);
        StringBuilder builder = new StringBuilder("RAW(");
        NodeIds.appendNamespace(builder, namespace);
        builder.append(';');
        NodeIds.appendNodeId(builder, node);
        builder.append(')');
        return builder.toString();
    }

    public static String nodeValue(int namespace, ByteString node) {
        Objects.requireNonNull(namespace);
        Objects.requireNonNull(node);
        StringBuilder builder = new StringBuilder("RAW(");
        NodeIds.appendNamespace(builder, namespace);
        builder.append(';');
        NodeIds.appendNodeId(builder, node);
        builder.append(')');
        return builder.toString();
    }

    private static void appendNamespace(StringBuilder builder, String namespace) {
        builder.append("nsu=").append(namespace);
    }

    private static void appendNamespace(StringBuilder builder, int namespace) {
        builder.append("ns=").append(Integer.toUnsignedString(namespace));
    }

    private static void appendNodeId(StringBuilder builder, String nodeId) {
        builder.append("s=").append(nodeId);
    }

    private static void appendNodeId(StringBuilder builder, int nodeId) {
        builder.append("i=").append(Integer.toUnsignedString(nodeId));
    }

    private static void appendNodeId(StringBuilder builder, UUID nodeId) {
        builder.append("g=").append(nodeId);
    }

    private static void appendNodeId(StringBuilder builder, ByteString nodeId) {
        builder.append("b=").append(Base64.getEncoder().encodeToString(nodeId.bytes()));
    }
}

