/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.atomix.ha.springboot;

import io.atomix.catalyst.transport.Address;
import java.util.stream.Collectors;
import org.apache.camel.component.atomix.ha.AtomixClusterClientService;
import org.apache.camel.component.atomix.ha.AtomixClusterService;
import org.apache.camel.component.atomix.ha.springboot.AtomixClusterServiceConfiguration;
import org.apache.camel.ha.CamelClusterService;
import org.apache.camel.spring.boot.CamelAutoConfiguration;
import org.apache.camel.spring.boot.ha.ClusteredRouteControllerAutoConfiguration;
import org.apache.camel.util.ObjectHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;
import org.springframework.context.annotation.Scope;

@Configuration
@AutoConfigureBefore(value={ClusteredRouteControllerAutoConfiguration.class, CamelAutoConfiguration.class})
@Conditional(value={AutoConfigurationCondition.class})
@EnableConfigurationProperties(value={AtomixClusterServiceConfiguration.class})
public class AtomixClusterServiceAutoConfiguration {
    @Autowired
    private AtomixClusterServiceConfiguration configuration;

    @Bean(name={"atomix-cluster-service"})
    @Scope(value="singleton")
    @ConditionalOnProperty(prefix="camel.component.atomix.cluster.service", name={"mode"}, havingValue="node")
    public CamelClusterService atomixClusterService() {
        AtomixClusterService service = new AtomixClusterService();
        service.setNodes(this.configuration.getNodes().stream().map(Address::new).collect(Collectors.toList()));
        ObjectHelper.ifNotEmpty((Object)this.configuration.isEphemeral(), arg_0 -> ((AtomixClusterService)service).setEphemeral(arg_0));
        ObjectHelper.ifNotEmpty((Object)this.configuration.getId(), arg_0 -> ((AtomixClusterService)service).setId(arg_0));
        ObjectHelper.ifNotEmpty((Object)this.configuration.getAddress(), arg_0 -> ((AtomixClusterService)service).setAddress(arg_0));
        ObjectHelper.ifNotEmpty((Object)this.configuration.getStoragePath(), arg_0 -> ((AtomixClusterService)service).setStoragePath(arg_0));
        ObjectHelper.ifNotEmpty((Object)this.configuration.getStorageLevel(), arg_0 -> ((AtomixClusterService)service).setStorageLevel(arg_0));
        ObjectHelper.ifNotEmpty((Object)this.configuration.getConfigurationUri(), arg_0 -> ((AtomixClusterService)service).setConfigurationUri(arg_0));
        ObjectHelper.ifNotEmpty(this.configuration.getAttributes(), arg_0 -> ((AtomixClusterService)service).setAttributes(arg_0));
        ObjectHelper.ifNotEmpty((Object)this.configuration.getOrder(), arg_0 -> ((AtomixClusterService)service).setOrder(arg_0));
        return service;
    }

    @Bean(name={"atomix-cluster-client-service"})
    @Scope(value="singleton")
    @ConditionalOnProperty(prefix="camel.component.atomix.cluster.service", name={"mode"}, havingValue="client")
    public CamelClusterService atomixClusterClientService() {
        AtomixClusterClientService service = new AtomixClusterClientService();
        service.setNodes(this.configuration.getNodes().stream().map(Address::new).collect(Collectors.toList()));
        ObjectHelper.ifNotEmpty((Object)this.configuration.getId(), arg_0 -> ((AtomixClusterClientService)service).setId(arg_0));
        ObjectHelper.ifNotEmpty((Object)this.configuration.getConfigurationUri(), arg_0 -> ((AtomixClusterClientService)service).setConfigurationUri(arg_0));
        ObjectHelper.ifNotEmpty(this.configuration.getAttributes(), arg_0 -> ((AtomixClusterClientService)service).setAttributes(arg_0));
        ObjectHelper.ifNotEmpty((Object)this.configuration.getOrder(), arg_0 -> ((AtomixClusterClientService)service).setOrder(arg_0));
        return service;
    }

    public static class AutoConfigurationCondition
    extends AllNestedConditions {
        public AutoConfigurationCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnProperty(prefix="camel.component.atomix.cluster.service", name={"mode"})
        static class WithMode {
            WithMode() {
            }
        }

        @ConditionalOnProperty(prefix="camel.component.atomix.cluster.service", name={"enabled"})
        static class IfEnabled {
            IfEnabled() {
            }
        }
    }
}

