/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.aws.kinesis;

import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.model.Record;
import com.amazonaws.services.kinesis.model.ShardIteratorType;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.aws.kinesis.KinesisComponent;
import org.apache.camel.component.aws.kinesis.KinesisConsumer;
import org.apache.camel.component.aws.kinesis.KinesisProducer;
import org.apache.camel.impl.ScheduledPollEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;

@UriEndpoint(firstVersion="2.17.0", scheme="aws-kinesis", title="AWS Kinesis", syntax="aws-kinesis:streamName", consumerClass=KinesisConsumer.class, label="cloud,messaging")
public class KinesisEndpoint
extends ScheduledPollEndpoint {
    @UriPath(description="Name of the stream")
    @Metadata(required="true")
    private String streamName;
    @UriParam(description="Amazon Kinesis client to use for all requests for this endpoint")
    @Metadata(required="true")
    private AmazonKinesis amazonKinesisClient;
    @UriParam(label="consumer", description="Maximum number of records that will be fetched in each poll", defaultValue="1")
    private int maxResultsPerRequest = 1;
    @UriParam(label="consumer", description="Defines where in the Kinesis stream to start getting records", defaultValue="TRIM_HORIZON")
    private ShardIteratorType iteratorType = ShardIteratorType.TRIM_HORIZON;
    @UriParam(label="consumer", description="Defines which shardId in the Kinesis stream to get records from")
    private String shardId = "";
    @UriParam(label="consumer", description="The sequence number to start polling from. Required if iteratorType is set to AFTER_SEQUENCE_NUMBER or AT_SEQUENCE_NUMBER")
    private String sequenceNumber = "";

    public KinesisEndpoint(String uri, String streamName, KinesisComponent component) {
        super(uri, (Component)component);
        this.streamName = streamName;
    }

    protected void doStart() throws Exception {
        if ((this.iteratorType.equals((Object)ShardIteratorType.AFTER_SEQUENCE_NUMBER) || this.iteratorType.equals((Object)ShardIteratorType.AT_SEQUENCE_NUMBER)) && this.sequenceNumber.isEmpty()) {
            throw new IllegalArgumentException("Sequence Number must be specified with iterator Types AFTER_SEQUENCE_NUMBER or AT_SEQUENCE_NUMBER");
        }
        super.doStart();
    }

    public Producer createProducer() throws Exception {
        return new KinesisProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        KinesisConsumer consumer = new KinesisConsumer(this, processor);
        consumer.setSchedulerProperties(this.getSchedulerProperties());
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    public Exchange createExchange(Record record) {
        Exchange exchange = super.createExchange();
        exchange.getIn().setBody((Object)record);
        exchange.getIn().setHeader("CamelAwsKinesisApproximateArrivalTimestamp", (Object)record.getApproximateArrivalTimestamp());
        exchange.getIn().setHeader("CamelAwsKinesisPartitionKey", (Object)record.getPartitionKey());
        exchange.getIn().setHeader("CamelAwsKinesisSequenceNumber", (Object)record.getSequenceNumber());
        return exchange;
    }

    public boolean isSingleton() {
        return true;
    }

    AmazonKinesis getClient() {
        return this.amazonKinesisClient;
    }

    public AmazonKinesis getAmazonKinesisClient() {
        return this.amazonKinesisClient;
    }

    public void setAmazonKinesisClient(AmazonKinesis amazonKinesisClient) {
        this.amazonKinesisClient = amazonKinesisClient;
    }

    public int getMaxResultsPerRequest() {
        return this.maxResultsPerRequest;
    }

    public void setMaxResultsPerRequest(int maxResultsPerRequest) {
        this.maxResultsPerRequest = maxResultsPerRequest;
    }

    public String getStreamName() {
        return this.streamName;
    }

    public void setStreamName(String streamName) {
        this.streamName = streamName;
    }

    public ShardIteratorType getIteratorType() {
        return this.iteratorType;
    }

    public void setIteratorType(ShardIteratorType iteratorType) {
        this.iteratorType = iteratorType;
    }

    public String getShardId() {
        return this.shardId;
    }

    public void setShardId(String shardId) {
        this.shardId = shardId;
    }

    public String getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(String sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }
}

