/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow.handlers;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.util.PathTemplate;
import io.undertow.util.URLUtils;
import org.apache.camel.component.undertow.handlers.CamelMethodHandler;
import org.apache.camel.component.undertow.handlers.CamelPathHandler;
import org.apache.camel.component.undertow.handlers.CamelPathTemplateHandler;

public class CamelRootHandler
implements HttpHandler {
    private CamelPathHandler pathHandler;

    public CamelRootHandler(HttpHandler defaultHandler) {
        this.pathHandler = new CamelPathHandler(defaultHandler);
    }

    public void handleRequest(HttpServerExchange exchange) throws Exception {
        this.pathHandler.handleRequest(exchange);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void add(String path, String[] methods, boolean prefixMatch, HttpHandler handler) {
        CamelMethodHandler targetHandler;
        String basePath = this.getBasePath(path);
        HttpHandler basePathHandler = this.pathHandler.getHandler(basePath);
        if (path.contains("{")) {
            String relativePath = path.substring(basePath.length());
            if (basePathHandler instanceof CamelPathTemplateHandler) {
                CamelPathTemplateHandler templateHandler = (CamelPathTemplateHandler)basePathHandler;
                targetHandler = templateHandler.get(relativePath);
                if (targetHandler == null) {
                    targetHandler = new CamelMethodHandler();
                    templateHandler.add(relativePath, targetHandler);
                }
            } else {
                CamelPathTemplateHandler templateHandler;
                if (basePathHandler instanceof CamelMethodHandler) {
                    templateHandler = new CamelPathTemplateHandler((CamelMethodHandler)basePathHandler);
                } else {
                    if (basePathHandler != null) throw new IllegalArgumentException(String.format("Unsupported handler '%s' was found", basePathHandler));
                    templateHandler = new CamelPathTemplateHandler(new CamelMethodHandler());
                }
                targetHandler = new CamelMethodHandler();
                templateHandler.add(relativePath, targetHandler);
                this.pathHandler.addPrefixPath(basePath, templateHandler);
            }
        } else if (basePathHandler instanceof CamelPathTemplateHandler) {
            CamelPathTemplateHandler templateHandler = (CamelPathTemplateHandler)basePathHandler;
            if (prefixMatch) throw new IllegalArgumentException(String.format("Duplicate handlers on a path '%s'", path));
            targetHandler = templateHandler.getDefault();
        } else if (basePathHandler instanceof CamelMethodHandler) {
            targetHandler = (CamelMethodHandler)basePathHandler;
        } else {
            if (basePathHandler != null) throw new IllegalArgumentException(String.format("Unsupported handler '%s' was found", basePathHandler));
            targetHandler = new CamelMethodHandler();
            if (prefixMatch) {
                this.pathHandler.addPrefixPath(basePath, targetHandler);
            } else {
                this.pathHandler.addExactPath(basePath, targetHandler);
            }
        }
        if (methods != null && methods.length != 0) {
            targetHandler.add(methods, handler);
            return;
        } else {
            targetHandler.addDefault(handler);
        }
    }

    public synchronized void remove(String path, String[] methods, boolean prefixMatch) {
        String basePath = this.getBasePath(path);
        HttpHandler basePathHandler = this.pathHandler.getHandler(basePath);
        if (basePathHandler == null) {
            return;
        }
        if (path.contains("{")) {
            String relativePath = path.substring(basePath.length());
            CamelPathTemplateHandler templateHandler = (CamelPathTemplateHandler)basePathHandler;
            CamelMethodHandler targetHandler = templateHandler.get(relativePath);
            if (methods != null && methods.length != 0) {
                targetHandler.remove(methods);
            } else {
                targetHandler.removeDefault();
            }
            if (targetHandler.isEmpty()) {
                templateHandler.remove(relativePath);
                if (templateHandler.isEmpty()) {
                    this.pathHandler.removePrefixPath(basePath);
                }
            }
        } else if (basePathHandler instanceof CamelPathTemplateHandler) {
            String relativePath = path.substring(basePath.length());
            CamelPathTemplateHandler templateHandler = (CamelPathTemplateHandler)basePathHandler;
            CamelMethodHandler targetHandler = templateHandler.getDefault();
            if (methods != null && methods.length != 0) {
                targetHandler.remove(methods);
            } else {
                targetHandler.removeDefault();
            }
            if (targetHandler.isEmpty()) {
                templateHandler.remove(relativePath);
                if (templateHandler.isEmpty()) {
                    this.pathHandler.removePrefixPath(basePath);
                }
            }
        } else {
            CamelMethodHandler targetHandler = (CamelMethodHandler)basePathHandler;
            if (methods != null && methods.length != 0) {
                targetHandler.remove(methods);
            } else {
                targetHandler.removeDefault();
            }
            if (targetHandler.isEmpty()) {
                if (prefixMatch) {
                    this.pathHandler.removePrefixPath(basePath);
                } else {
                    this.pathHandler.removeExactPath(basePath);
                }
            }
        }
    }

    public synchronized boolean isEmpty() {
        return this.pathHandler.isEmpty();
    }

    public String toString() {
        return this.pathHandler.toString();
    }

    private String getBasePath(String path) {
        if (path.contains("{")) {
            path = PathTemplate.create((String)path).getBase();
        }
        return URLUtils.normalizeSlashes((String)path);
    }
}

