/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.google.mail;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.googleapis.auth.oauth2.GoogleCredential;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.gmail.Gmail;
import java.util.Collection;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.google.mail.GoogleMailClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchGoogleMailClientFactory
implements GoogleMailClientFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BatchGoogleMailClientFactory.class);
    private NetHttpTransport transport = new NetHttpTransport();
    private JacksonFactory jsonFactory = new JacksonFactory();

    @Override
    public Gmail makeClient(String clientId, String clientSecret, Collection<String> scopes, String applicationName, String refreshToken, String accessToken) {
        if (clientId == null || clientSecret == null) {
            throw new IllegalArgumentException("clientId and clientSecret are required to create Gmail client.");
        }
        try {
            Credential credential = this.authorize(clientId, clientSecret, scopes);
            if (refreshToken != null && !"".equals(refreshToken)) {
                credential.setRefreshToken(refreshToken);
            }
            if (accessToken != null && !"".equals(accessToken)) {
                credential.setAccessToken(accessToken);
            }
            return new Gmail.Builder((HttpTransport)this.transport, (JsonFactory)this.jsonFactory, (HttpRequestInitializer)credential).setApplicationName(applicationName).build();
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Could not create Gmail client.", (Throwable)e);
        }
    }

    private Credential authorize(String clientId, String clientSecret, Collection<String> scopes) throws Exception {
        return new GoogleCredential.Builder().setJsonFactory((JsonFactory)this.jsonFactory).setTransport((HttpTransport)this.transport).setClientSecrets(clientId, clientSecret).build();
    }
}

