/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.cxf.jaxrs;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.cxf.jaxrs.CxfRsEndpoint;
import org.apache.camel.component.cxf.jaxrs.CxfRsInvoker;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.invoker.Invoker;
import org.apache.cxf.transport.MessageObserver;

public class CxfRsConsumer
extends DefaultConsumer {
    private Server server = this.createServer();

    public CxfRsConsumer(CxfRsEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
    }

    protected Server createServer() {
        CxfRsEndpoint endpoint = (CxfRsEndpoint)this.getEndpoint();
        CxfRsInvoker cxfRsInvoker = new CxfRsInvoker(endpoint, this);
        JAXRSServerFactoryBean svrBean = endpoint.createJAXRSServerFactoryBean();
        Bus bus = endpoint.getBus();
        if (bus != null) {
            svrBean.setBus(bus);
        }
        svrBean.setInvoker((Invoker)cxfRsInvoker);
        svrBean.getOutInterceptors().add(new UnitOfWorkCloserInterceptor());
        Server server = svrBean.create();
        MessageObserver originalOutFaultObserver = server.getEndpoint().getOutFaultObserver();
        server.getEndpoint().setOutFaultObserver(message -> {
            Exchange exchange;
            org.apache.cxf.message.Exchange cxfExchange = null;
            cxfExchange = message.getExchange();
            if (cxfExchange != null && (exchange = (Exchange)cxfExchange.get(Exchange.class)) != null) {
                this.doneUoW(exchange);
            }
            originalOutFaultObserver.onMessage(message);
        });
        return server;
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.server == null) {
            this.server = this.createServer();
        }
        this.server.start();
    }

    protected void doStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
            this.server.destroy();
            this.server = null;
        }
        super.doStop();
    }

    public Server getServer() {
        return this.server;
    }

    private class UnitOfWorkCloserInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public UnitOfWorkCloserInterceptor() {
            super("post-logical-ending");
        }

        public void handleMessage(Message message) throws Fault {
            Exchange exchange;
            org.apache.cxf.message.Exchange cxfExchange = null;
            cxfExchange = message.getExchange();
            if (cxfExchange != null && (exchange = (Exchange)cxfExchange.get(Exchange.class)) != null) {
                CxfRsConsumer.this.doneUoW(exchange);
            }
        }
    }
}

