/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.internal.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.thoughtworks.xstream.MarshallingStrategy;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.XStreamException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.reflection.FieldDictionary;
import com.thoughtworks.xstream.converters.reflection.FieldKeySorter;
import com.thoughtworks.xstream.converters.reflection.PureJavaReflectionProvider;
import com.thoughtworks.xstream.converters.reflection.ReflectionProvider;
import com.thoughtworks.xstream.core.TreeMarshallingStrategy;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.naming.NameCoder;
import com.thoughtworks.xstream.io.naming.NoNameCoder;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import com.thoughtworks.xstream.io.xml.XppDriver;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.camel.component.salesforce.SalesforceEndpointConfig;
import org.apache.camel.component.salesforce.SalesforceHttpClient;
import org.apache.camel.component.salesforce.api.NoSuchSObjectException;
import org.apache.camel.component.salesforce.api.SalesforceException;
import org.apache.camel.component.salesforce.api.dto.AnnotationFieldKeySorter;
import org.apache.camel.component.salesforce.api.dto.RestError;
import org.apache.camel.component.salesforce.api.dto.composite.SObjectBatch;
import org.apache.camel.component.salesforce.api.dto.composite.SObjectBatchResponse;
import org.apache.camel.component.salesforce.api.dto.composite.SObjectTree;
import org.apache.camel.component.salesforce.api.dto.composite.SObjectTreeResponse;
import org.apache.camel.component.salesforce.api.utils.DateTimeConverter;
import org.apache.camel.component.salesforce.api.utils.JsonUtils;
import org.apache.camel.component.salesforce.api.utils.Version;
import org.apache.camel.component.salesforce.internal.PayloadFormat;
import org.apache.camel.component.salesforce.internal.SalesforceSession;
import org.apache.camel.component.salesforce.internal.client.AbstractClientBase;
import org.apache.camel.component.salesforce.internal.client.CompositeApiClient;
import org.apache.camel.component.salesforce.internal.client.XStreamUtils;
import org.apache.camel.util.ObjectHelper;
import org.eclipse.jetty.client.api.ContentProvider;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.util.InputStreamContentProvider;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCompositeApiClient
extends AbstractClientBase
implements CompositeApiClient {
    private static final Class[] ADDITIONAL_TYPES = new Class[]{SObjectTree.class, SObjectTreeResponse.class, SObjectBatchResponse.class};
    private static final Logger LOG = LoggerFactory.getLogger(DefaultCompositeApiClient.class);
    private final PayloadFormat format;
    private ObjectMapper mapper;
    private final Map<Class<?>, ObjectReader> readers = new HashMap();
    private final Map<Class<?>, ObjectWriter> writters = new HashMap();
    private final XStream xStream;

    public DefaultCompositeApiClient(SalesforceEndpointConfig configuration, PayloadFormat format, String version, SalesforceSession session, SalesforceHttpClient httpClient) throws SalesforceException {
        super(version, session, httpClient);
        this.format = format;
        this.mapper = configuration.getObjectMapper() != null ? configuration.getObjectMapper() : JsonUtils.createObjectMapper();
        this.xStream = DefaultCompositeApiClient.configureXStream();
    }

    static XStream configureXStream() {
        PureJavaReflectionProvider reflectionProvider = new PureJavaReflectionProvider(new FieldDictionary((FieldKeySorter)new AnnotationFieldKeySorter()));
        XppDriver hierarchicalStreamDriver = new XppDriver((NameCoder)new NoNameCoder()){

            public HierarchicalStreamWriter createWriter(Writer out) {
                return new CompactWriter(out, this.getNameCoder());
            }
        };
        XStream xStream = new XStream((ReflectionProvider)reflectionProvider, (HierarchicalStreamDriver)hierarchicalStreamDriver);
        xStream.aliasSystemAttribute(null, "class");
        xStream.ignoreUnknownElements();
        XStreamUtils.addDefaultPermissions(xStream);
        xStream.registerConverter((Converter)new DateTimeConverter());
        xStream.setMarshallingStrategy((MarshallingStrategy)new TreeMarshallingStrategy());
        xStream.processAnnotations(ADDITIONAL_TYPES);
        return xStream;
    }

    @Override
    public void submitCompositeBatch(SObjectBatch batch, CompositeApiClient.ResponseCallback<SObjectBatchResponse> callback) throws SalesforceException {
        DefaultCompositeApiClient.checkCompositeBatchVersion(this.version, batch.getVersion());
        String url = this.versionUrl() + "composite/batch";
        Request post = this.createRequest(HttpMethod.POST, url);
        ContentProvider content = this.serialize(batch, batch.objectTypes());
        post.content(content);
        this.doHttpRequest(post, (response, exception) -> callback.onResponse(this.tryToReadResponse(SObjectBatchResponse.class, response), exception));
    }

    @Override
    public void submitCompositeTree(SObjectTree tree, CompositeApiClient.ResponseCallback<SObjectTreeResponse> callback) throws SalesforceException {
        String url = this.versionUrl() + "composite/tree/" + tree.getObjectType();
        Request post = this.createRequest(HttpMethod.POST, url);
        ContentProvider content = this.serialize(tree, tree.objectTypes());
        post.content(content);
        this.doHttpRequest(post, (response, exception) -> callback.onResponse(this.tryToReadResponse(SObjectTreeResponse.class, response), exception));
    }

    static void checkCompositeBatchVersion(String configuredVersion, Version batchVersion) throws SalesforceException {
        if (Version.create(configuredVersion).compareTo(batchVersion) < 0) {
            throw new SalesforceException("Component is configured with Salesforce API version " + configuredVersion + ", but the payload of the Composite API batch operation requires at least " + batchVersion, 0);
        }
    }

    Request createRequest(HttpMethod method, String url) {
        Request request = this.getRequest(method, url);
        this.setAccessToken(request);
        if (this.format == PayloadFormat.JSON) {
            request.header(HttpHeader.CONTENT_TYPE, "application/json;charset=utf-8");
            request.header(HttpHeader.ACCEPT, "application/json;charset=utf-8");
        } else {
            request.header(HttpHeader.CONTENT_TYPE, "application/xml;charset=utf-8");
            request.header(HttpHeader.ACCEPT, "application/xml;charset=utf-8");
        }
        request.header(HttpHeader.ACCEPT_CHARSET, "utf-8");
        return request;
    }

    <T> T fromJson(Class<T> expectedType, InputStream responseStream) throws IOException {
        return (T)this.jsonReaderFor(expectedType).readValue(responseStream);
    }

    <T> T fromXml(InputStream responseStream) {
        Object read = this.xStream.fromXML(responseStream);
        return (T)read;
    }

    ObjectReader jsonReaderFor(Class<?> type) {
        return Optional.ofNullable(this.readers.get(type)).orElseGet(() -> this.mapper.readerFor(type));
    }

    ObjectWriter jsonWriterFor(Object obj) {
        Class<?> type = obj.getClass();
        return Optional.ofNullable(this.writters.get(type)).orElseGet(() -> this.mapper.writerFor(type));
    }

    ContentProvider serialize(Object body, Class<?> ... additionalTypes) throws SalesforceException {
        InputStream stream = this.format == PayloadFormat.JSON ? this.toJson(body) : this.toXml(body, additionalTypes);
        return new InputStreamContentProvider(stream);
    }

    String servicesDataUrl() {
        return this.instanceUrl + "/services/data/";
    }

    InputStream toJson(Object obj) throws SalesforceException {
        byte[] jsonBytes;
        try {
            jsonBytes = this.jsonWriterFor(obj).writeValueAsBytes(obj);
        }
        catch (JsonProcessingException e) {
            throw new SalesforceException("Unable to serialize given SObjectTree to JSON", e);
        }
        return new ByteArrayInputStream(jsonBytes);
    }

    InputStream toXml(Object obj, Class<?> ... additionalTypes) {
        this.xStream.processAnnotations((Class[])additionalTypes);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.xStream.toXML(obj, (OutputStream)out);
        return new ByteArrayInputStream(out.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> Optional<T> tryToReadResponse(Class<T> expectedType, InputStream responseStream) {
        Optional<T> optional;
        if (responseStream == null) {
            return Optional.empty();
        }
        try {
            if (this.format == PayloadFormat.JSON) {
                Optional<T> optional2 = Optional.of(this.fromJson(expectedType, responseStream));
                return optional2;
            }
            optional = Optional.of(this.fromXml(responseStream));
        }
        catch (XStreamException | IOException e) {
            LOG.warn("Unable to read response from the Composite API", e);
            Optional optional3 = Optional.empty();
            return optional3;
        }
        finally {
            try {
                responseStream.close();
            }
            catch (IOException iOException) {}
        }
        return optional;
    }

    String versionUrl() {
        ObjectHelper.notNull((Object)this.version, (String)"version");
        return this.servicesDataUrl() + "v" + this.version + "/";
    }

    @Override
    protected SalesforceException createRestException(Response response, InputStream responseContent) {
        List<RestError> errors;
        try {
            errors = this.readErrorsFrom(responseContent, this.format, this.mapper, this.xStream);
        }
        catch (IOException e) {
            return new SalesforceException("Unable to read error response", e);
        }
        int status = response.getStatus();
        if (status == 404) {
            return new NoSuchSObjectException(errors);
        }
        String reason = response.getReason();
        return new SalesforceException("Unexpected error: " + reason, status);
    }

    @Override
    protected void setAccessToken(Request request) {
        request.getHeaders().put("Authorization", "Bearer " + this.accessToken);
    }
}

