/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.salesforce.api.utils;

import java.time.DateTimeException;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.util.regex.Pattern;

public abstract class DateTimeUtils {
    private static final Pattern BAD_TZ_PATTERN = Pattern.compile("[+-][0-9]{4}+$");
    private static final DateTimeFormatter ISO_8601_FORMATTER = new DateTimeFormatterBuilder().parseCaseInsensitive().appendPattern("yyyy-MM-dd").appendLiteral('T').appendPattern("HH:mm:ss[.SSS]").appendOffset("+HH:MM", "Z").toFormatter();

    public static String formatDateTime(ZonedDateTime dateTime) throws DateTimeException {
        return ISO_8601_FORMATTER.format(dateTime);
    }

    public static ZonedDateTime parseDateTime(String dateTimeStr) throws DateTimeParseException {
        return ISO_8601_FORMATTER.parse((CharSequence)DateTimeUtils.normalizeDateTime(dateTimeStr), ZonedDateTime::from);
    }

    private static String normalizeDateTime(String dateTimeAsString) {
        if (BAD_TZ_PATTERN.matcher(dateTimeAsString).find()) {
            int splitAt = dateTimeAsString.length() - 2;
            dateTimeAsString = dateTimeAsString.substring(0, splitAt) + ":" + dateTimeAsString.substring(splitAt);
        }
        return dateTimeAsString;
    }
}

