/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.jsonpath;

import com.jayway.jsonpath.Option;
import org.apache.camel.AfterPropertiesConfigured;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.ExpressionEvaluationException;
import org.apache.camel.ExpressionIllegalSyntaxException;
import org.apache.camel.jsonpath.JsonPathEngine;
import org.apache.camel.jsonpath.easypredicate.EasyPredicateParser;
import org.apache.camel.support.ExpressionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonPathExpression
extends ExpressionAdapter
implements AfterPropertiesConfigured {
    private static final Logger LOG = LoggerFactory.getLogger(JsonPathExpression.class);
    private final String expression;
    private JsonPathEngine engine;
    private boolean predicate;
    private Class<?> resultType;
    private boolean suppressExceptions;
    private boolean allowSimple = true;
    private boolean allowEasyPredicate = true;
    private Option[] options;

    public JsonPathExpression(String expression) {
        this.expression = expression;
    }

    public boolean isPredicate() {
        return this.predicate;
    }

    public void setPredicate(boolean predicate) {
        this.predicate = predicate;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public void setResultType(Class<?> resultType) {
        this.resultType = resultType;
    }

    public boolean isSuppressExceptions() {
        return this.suppressExceptions;
    }

    public void setSuppressExceptions(boolean suppressExceptions) {
        this.suppressExceptions = suppressExceptions;
    }

    public boolean isAllowSimple() {
        return this.allowSimple;
    }

    public void setAllowSimple(boolean allowSimple) {
        this.allowSimple = allowSimple;
    }

    public boolean isAllowEasyPredicate() {
        return this.allowEasyPredicate;
    }

    public void setAllowEasyPredicate(boolean allowEasyPredicate) {
        this.allowEasyPredicate = allowEasyPredicate;
    }

    public Option[] getOptions() {
        return this.options;
    }

    public void setOptions(Option[] options) {
        this.options = options;
    }

    public Object evaluate(Exchange exchange) {
        try {
            Object result = this.evaluateJsonPath(exchange, this.engine);
            if (this.resultType != null) {
                return exchange.getContext().getTypeConverter().convertTo(this.resultType, exchange, result);
            }
            return result;
        }
        catch (Exception e) {
            throw new ExpressionEvaluationException((Expression)this, exchange, (Throwable)e);
        }
    }

    public void afterPropertiesConfigured(CamelContext camelContext) {
        this.init();
    }

    public void init() {
        EasyPredicateParser parser;
        String exp = this.expression;
        if (this.predicate && this.isAllowEasyPredicate() && !(exp = (parser = new EasyPredicateParser()).parse(this.expression)).equals(this.expression)) {
            LOG.debug("EasyPredicateParser parsed {} -> {}", (Object)this.expression, (Object)exp);
        }
        LOG.debug("Initializing {} using: {}", (Object)(this.predicate ? "predicate" : "expression"), (Object)exp);
        try {
            this.engine = new JsonPathEngine(exp, this.suppressExceptions, this.allowSimple, this.options);
        }
        catch (Exception e) {
            throw new ExpressionIllegalSyntaxException(exp, (Throwable)e);
        }
    }

    public String toString() {
        return "jsonpath[" + this.expression + "]";
    }

    private Object evaluateJsonPath(Exchange exchange, JsonPathEngine engine) throws Exception {
        return engine.read(exchange);
    }
}

