/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.ServiceStatus;
import org.apache.camel.api.management.ManagedAttribute;
import org.apache.camel.component.direct.DirectEndpoint;
import org.apache.camel.component.twitter.TwitterComponent;
import org.apache.camel.component.twitter.TwitterConfiguration;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.TwitterHelper;
import org.apache.camel.component.twitter.consumer.TwitterConsumer;
import org.apache.camel.component.twitter.consumer.TwitterConsumerDirect;
import org.apache.camel.component.twitter.data.EndpointType;

public class TwitterEndpointDirect
extends DirectEndpoint
implements TwitterEndpoint {
    private final String remaining;
    private TwitterConfiguration properties;

    public TwitterEndpointDirect(String uri, String remaining, TwitterComponent component, TwitterConfiguration properties) {
        super(uri, (Component)component);
        this.remaining = remaining;
        this.properties = properties;
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        TwitterConsumer twitter4jConsumer = TwitterHelper.createConsumer(this, this.getEndpointUri(), this.remaining);
        TwitterConsumerDirect answer = new TwitterConsumerDirect(this, processor, twitter4jConsumer);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public Producer createProducer() throws Exception {
        return TwitterHelper.createProducer(this, this.getEndpointUri(), this.remaining);
    }

    @ManagedAttribute
    public boolean isSingleton() {
        return true;
    }

    @Override
    public TwitterConfiguration getProperties() {
        return this.properties;
    }

    public void setProperties(TwitterConfiguration properties) {
        this.properties = properties;
    }

    @ManagedAttribute(description="Camel ID")
    public String getCamelId() {
        return this.getCamelContext().getName();
    }

    @ManagedAttribute(description="Camel ManagementName")
    public String getCamelManagementName() {
        return this.getCamelContext().getManagementName();
    }

    @ManagedAttribute(description="Endpoint Uri", mask=true)
    public String getEndpointUri() {
        return super.getEndpointUri();
    }

    @ManagedAttribute(description="Service State")
    public String getState() {
        ServiceStatus status = this.getStatus();
        if (status == null) {
            status = ServiceStatus.Stopped;
        }
        return status.name();
    }

    @ManagedAttribute
    public String getKeywords() {
        return this.getProperties().getKeywords();
    }

    @ManagedAttribute
    public void setKeywords(String keywords) {
        this.getProperties().setKeywords(keywords);
    }

    @ManagedAttribute
    public String getLocations() {
        return this.getProperties().getLocations();
    }

    @ManagedAttribute
    public void setLocations(String locations) {
        this.getProperties().setLocations(locations);
    }

    @ManagedAttribute
    public void setFilterOld(boolean filterOld) {
        this.getProperties().setFilterOld(filterOld);
    }

    @ManagedAttribute
    public boolean isFilterOld() {
        return this.getProperties().isFilterOld();
    }

    @ManagedAttribute
    public void setSinceId(long sinceId) {
        this.getProperties().setSinceId(sinceId);
    }

    @ManagedAttribute
    public long getSinceId() {
        return this.getProperties().getSinceId();
    }

    @ManagedAttribute
    public void setLang(String lang) {
        this.getProperties().setLang(lang);
    }

    @ManagedAttribute
    public String getLang() {
        return this.getProperties().getLang();
    }

    @ManagedAttribute
    public void setCount(Integer count) {
        this.getProperties().setCount(count);
    }

    @ManagedAttribute
    public Integer getCount() {
        return this.getProperties().getCount();
    }

    @ManagedAttribute
    public void setNumberOfPages(Integer numberOfPages) {
        this.getProperties().setNumberOfPages(numberOfPages);
    }

    @ManagedAttribute
    public Integer getNumberOfPages() {
        return this.getProperties().getNumberOfPages();
    }

    @Override
    public EndpointType getEndpointType() {
        return EndpointType.DIRECT;
    }

    public ExchangePattern getExchangePattern() {
        return ExchangePattern.InOptionalOut;
    }
}

