/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.server.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.component.milo.client.MiloClientConsumer;
import org.apache.camel.component.milo.server.internal.CamelServerItem;
import org.eclipse.milo.opcua.sdk.core.Reference;
import org.eclipse.milo.opcua.sdk.server.OpcUaServer;
import org.eclipse.milo.opcua.sdk.server.api.AccessContext;
import org.eclipse.milo.opcua.sdk.server.api.AttributeManager;
import org.eclipse.milo.opcua.sdk.server.api.DataItem;
import org.eclipse.milo.opcua.sdk.server.api.MonitoredItem;
import org.eclipse.milo.opcua.sdk.server.api.Namespace;
import org.eclipse.milo.opcua.sdk.server.api.OperationContext;
import org.eclipse.milo.opcua.sdk.server.api.ServerNodeMap;
import org.eclipse.milo.opcua.sdk.server.nodes.AttributeContext;
import org.eclipse.milo.opcua.sdk.server.nodes.ServerNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaFolderNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaNode;
import org.eclipse.milo.opcua.sdk.server.nodes.UaObjectNode;
import org.eclipse.milo.opcua.sdk.server.util.SubscriptionModel;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelNamespace
implements Namespace {
    private static final Logger LOG = LoggerFactory.getLogger(MiloClientConsumer.class);
    private final UShort namespaceIndex;
    private final String namespaceUri;
    private final ServerNodeMap nodeManager;
    private final SubscriptionModel subscriptionModel;
    private final UaFolderNode folder;
    private final UaObjectNode itemsObject;
    private final Map<String, CamelServerItem> itemMap = new HashMap<String, CamelServerItem>();

    public CamelNamespace(UShort namespaceIndex, String namespaceUri, OpcUaServer server) {
        this.namespaceIndex = namespaceIndex;
        this.namespaceUri = namespaceUri;
        this.nodeManager = server.getNodeMap();
        this.subscriptionModel = new SubscriptionModel(server, (AttributeManager)this);
        NodeId nodeId = new NodeId(namespaceIndex, "camel");
        QualifiedName name = new QualifiedName(namespaceIndex, "camel");
        LocalizedText displayName = LocalizedText.english((String)"Camel");
        this.folder = new UaFolderNode(this.nodeManager, nodeId, name, displayName);
        this.nodeManager.addNode((ServerNode)this.folder);
        nodeId = new NodeId(namespaceIndex, "items");
        name = new QualifiedName(namespaceIndex, "items");
        displayName = LocalizedText.english((String)"Items");
        this.itemsObject = new UaObjectNode(this.nodeManager, nodeId, name, displayName);
        this.folder.addComponent((UaNode)this.itemsObject);
        try {
            server.getUaNamespace().addReference(Identifiers.ObjectsFolder, Identifiers.Organizes, true, this.folder.getNodeId().expanded(), NodeClass.Object);
        }
        catch (UaException e) {
            throw new RuntimeException("Failed to register folder", e);
        }
    }

    public UShort getNamespaceIndex() {
        return this.namespaceIndex;
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public CompletableFuture<List<Reference>> browse(AccessContext context, NodeId nodeId) {
        ServerNode node = (ServerNode)this.nodeManager.get((Object)nodeId);
        if (node != null) {
            return CompletableFuture.completedFuture(node.getReferences());
        }
        CompletableFuture<List<Reference>> f = new CompletableFuture<List<Reference>>();
        f.completeExceptionally(new UaException(2150891520L));
        return f;
    }

    public void read(AttributeManager.ReadContext context, Double maxAge, TimestampsToReturn timestamps, List<ReadValueId> readValueIds) {
        ArrayList results = Lists.newArrayListWithCapacity((int)readValueIds.size());
        for (ReadValueId id : readValueIds) {
            ServerNode node = (ServerNode)this.nodeManager.get((Object)id.getNodeId());
            DataValue value = node != null ? node.readAttribute(new AttributeContext((OperationContext)context), id.getAttributeId(), timestamps, id.getIndexRange()) : new DataValue(2150891520L);
            results.add(value);
        }
        context.complete((List)results);
    }

    public void write(AttributeManager.WriteContext context, List<WriteValue> writeValues) {
        ArrayList results = Lists.newArrayListWithCapacity((int)writeValues.size());
        for (WriteValue writeValue : writeValues) {
            try {
                ServerNode node = (ServerNode)this.nodeManager.getNode(writeValue.getNodeId()).orElseThrow(() -> new UaException(2150891520L));
                node.writeAttribute(new AttributeContext((OperationContext)context), writeValue.getAttributeId(), writeValue.getValue(), writeValue.getIndexRange());
                if (LOG.isTraceEnabled()) {
                    Variant variant = writeValue.getValue().getValue();
                    Object o = variant != null ? variant.getValue() : null;
                    LOG.trace("Wrote value={} to attributeId={} of {}", new Object[]{o, writeValue.getAttributeId(), writeValue.getNodeId()});
                }
                results.add(StatusCode.GOOD);
            }
            catch (UaException e) {
                results.add(e.getStatusCode());
            }
        }
        context.complete((List)results);
    }

    public void onDataItemsCreated(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsCreated(dataItems);
    }

    public void onDataItemsModified(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsModified(dataItems);
    }

    public void onDataItemsDeleted(List<DataItem> dataItems) {
        this.subscriptionModel.onDataItemsDeleted(dataItems);
    }

    public void onMonitoringModeChanged(List<MonitoredItem> monitoredItems) {
        this.subscriptionModel.onMonitoringModeChanged(monitoredItems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CamelServerItem getOrAddItem(String itemId) {
        CamelNamespace camelNamespace = this;
        synchronized (camelNamespace) {
            CamelServerItem item = this.itemMap.get(itemId);
            if (item == null) {
                item = new CamelServerItem(itemId, this.nodeManager, this.namespaceIndex, this.itemsObject);
                this.itemMap.put(itemId, item);
            }
            return item;
        }
    }
}

