/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.milo.client;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;

@UriParams
public class MiloClientConfiguration
implements Cloneable {
    private static final String DEFAULT_APPLICATION_URI = "http://camel.apache.org/EclipseMilo/Client";
    private static final String DEFAULT_APPLICATION_NAME = "Apache Camel adapter for Eclipse Milo";
    private static final String DEFAULT_PRODUCT_URI = "http://camel.apache.org/EclipseMilo";
    private String endpointUri;
    @UriParam
    private String clientId;
    @UriParam(label="client", defaultValue="Apache Camel adapter for Eclipse Milo")
    private String applicationName = "Apache Camel adapter for Eclipse Milo";
    @UriParam(label="client", defaultValue="http://camel.apache.org/EclipseMilo/Client")
    private String applicationUri = "http://camel.apache.org/EclipseMilo/Client";
    @UriParam(label="client", defaultValue="http://camel.apache.org/EclipseMilo")
    private String productUri = "http://camel.apache.org/EclipseMilo";
    @UriParam(label="client")
    private Long requestTimeout;
    @UriParam(label="client")
    private Long channelLifetime;
    @UriParam(label="client")
    private String sessionName;
    @UriParam(label="client")
    private Long sessionTimeout;
    @UriParam(label="client")
    private Long maxPendingPublishRequests;
    @UriParam(label="client")
    private Long maxResponseMessageSize;
    @UriParam(label="client")
    private Boolean secureChannelReauthenticationEnabled;
    @UriParam(label="client")
    private URL keyStoreUrl;
    @UriParam(label="client")
    private String keyStoreType = "PKCS12";
    @UriParam(label="client")
    private String keyAlias;
    @UriParam(label="client", secret=true)
    private String keyStorePassword;
    @UriParam(label="client", secret=true)
    private String keyPassword;

    public MiloClientConfiguration() {
    }

    public MiloClientConfiguration(MiloClientConfiguration other) {
        this.clientId = other.clientId;
        this.endpointUri = other.endpointUri;
        this.applicationName = other.applicationName;
        this.productUri = other.productUri;
        this.requestTimeout = other.requestTimeout;
    }

    public void setEndpointUri(String endpointUri) {
        this.endpointUri = endpointUri;
    }

    public String getEndpointUri() {
        return this.endpointUri;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationUri(String applicationUri) {
        this.applicationUri = applicationUri;
    }

    public String getApplicationUri() {
        return this.applicationUri;
    }

    public void setProductUri(String productUri) {
        this.productUri = productUri;
    }

    public String getProductUri() {
        return this.productUri;
    }

    public void setRequestTimeout(Long reconnectTimeout) {
        this.requestTimeout = reconnectTimeout;
    }

    public Long getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setChannelLifetime(Long channelLifetime) {
        this.channelLifetime = channelLifetime;
    }

    public Long getChannelLifetime() {
        return this.channelLifetime;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setSessionTimeout(Long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public Long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setMaxPendingPublishRequests(Long maxPendingPublishRequests) {
        this.maxPendingPublishRequests = maxPendingPublishRequests;
    }

    public Long getMaxPendingPublishRequests() {
        return this.maxPendingPublishRequests;
    }

    public void setMaxResponseMessageSize(Long maxResponseMessageSize) {
        this.maxResponseMessageSize = maxResponseMessageSize;
    }

    public Long getMaxResponseMessageSize() {
        return this.maxResponseMessageSize;
    }

    public void setSecureChannelReauthenticationEnabled(Boolean secureChannelReauthenticationEnabled) {
        this.secureChannelReauthenticationEnabled = secureChannelReauthenticationEnabled;
    }

    public Boolean getSecureChannelReauthenticationEnabled() {
        return this.secureChannelReauthenticationEnabled;
    }

    public void setKeyStoreUrl(String keyStoreUrl) throws MalformedURLException {
        this.keyStoreUrl = keyStoreUrl != null ? new URL(keyStoreUrl) : null;
    }

    public URL getKeyStoreUrl() {
        return this.keyStoreUrl;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public String getKeyStoreType() {
        return this.keyStoreType;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public String getKeyAlias() {
        return this.keyAlias;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public String getKeyStorePassword() {
        return this.keyStorePassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public MiloClientConfiguration clone() {
        return new MiloClientConfiguration(this);
    }

    public String toCacheId() {
        if (this.clientId != null && !this.clientId.isEmpty()) {
            return this.endpointUri + "|" + this.clientId;
        }
        return this.endpointUri;
    }
}

