/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.dropbox.integration.producer;

import org.apache.camel.Exchange;
import org.apache.camel.component.dropbox.DropboxConfiguration;
import org.apache.camel.component.dropbox.DropboxEndpoint;
import org.apache.camel.component.dropbox.core.DropboxAPIFacade;
import org.apache.camel.component.dropbox.dto.DropboxDelResult;
import org.apache.camel.component.dropbox.integration.producer.DropboxProducer;
import org.apache.camel.component.dropbox.util.DropboxResultHeader;

public class DropboxDelProducer
extends DropboxProducer {
    public DropboxDelProducer(DropboxEndpoint endpoint, DropboxConfiguration configuration) {
        super(endpoint, configuration);
    }

    public void process(Exchange exchange) throws Exception {
        DropboxDelResult result = new DropboxAPIFacade(this.configuration.getClient(), exchange).del(this.configuration.getRemotePath());
        exchange.getIn().setHeader(DropboxResultHeader.DELETED_PATH.name(), (Object)result.getEntry());
        exchange.getIn().setBody((Object)result.getEntry());
        this.log.debug("Deleted: {}", (Object)this.configuration.getRemotePath());
    }
}

