/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.docker.springboot;

import java.util.Map;
import org.apache.camel.component.docker.DockerConfiguration;
import org.apache.camel.component.docker.DockerOperation;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="camel.component.docker")
public class DockerComponentConfiguration {
    private DockerConfigurationNestedConfiguration configuration;
    private Boolean resolvePropertyPlaceholders = true;

    public DockerConfigurationNestedConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(DockerConfigurationNestedConfiguration configuration) {
        this.configuration = configuration;
    }

    public Boolean getResolvePropertyPlaceholders() {
        return this.resolvePropertyPlaceholders;
    }

    public void setResolvePropertyPlaceholders(Boolean resolvePropertyPlaceholders) {
        this.resolvePropertyPlaceholders = resolvePropertyPlaceholders;
    }

    public static class DockerConfigurationNestedConfiguration {
        public static final Class CAMEL_NESTED_CLASS = DockerConfiguration.class;
        private String host = "localhost";
        private Integer port = 2375;
        private String username;
        private String password;
        private String email;
        private String serverAddress = "https://index.docker.io/v1/";
        private Integer requestTimeout;
        private Boolean secure = false;
        private String certPath;
        private Integer maxTotalConnections = 100;
        private Integer maxPerRouteConnections = 100;
        private Boolean loggingFilter = false;
        private Boolean followRedirectFilter = false;
        private Map parameters;
        private DockerOperation operation;
        private Boolean tlsVerify = false;
        private Boolean socket = true;
        private String cmdExecFactory = "com.github.dockerjava.jaxrs.JerseyDockerCmdExecFactory";

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public Integer getPort() {
            return this.port;
        }

        public void setPort(Integer port) {
            this.port = port;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public String getEmail() {
            return this.email;
        }

        public void setEmail(String email) {
            this.email = email;
        }

        public String getServerAddress() {
            return this.serverAddress;
        }

        public void setServerAddress(String serverAddress) {
            this.serverAddress = serverAddress;
        }

        public Integer getRequestTimeout() {
            return this.requestTimeout;
        }

        public void setRequestTimeout(Integer requestTimeout) {
            this.requestTimeout = requestTimeout;
        }

        public Boolean getSecure() {
            return this.secure;
        }

        public void setSecure(Boolean secure) {
            this.secure = secure;
        }

        public String getCertPath() {
            return this.certPath;
        }

        public void setCertPath(String certPath) {
            this.certPath = certPath;
        }

        public Integer getMaxTotalConnections() {
            return this.maxTotalConnections;
        }

        public void setMaxTotalConnections(Integer maxTotalConnections) {
            this.maxTotalConnections = maxTotalConnections;
        }

        public Integer getMaxPerRouteConnections() {
            return this.maxPerRouteConnections;
        }

        public void setMaxPerRouteConnections(Integer maxPerRouteConnections) {
            this.maxPerRouteConnections = maxPerRouteConnections;
        }

        public Boolean getLoggingFilter() {
            return this.loggingFilter;
        }

        public void setLoggingFilter(Boolean loggingFilter) {
            this.loggingFilter = loggingFilter;
        }

        public Boolean getFollowRedirectFilter() {
            return this.followRedirectFilter;
        }

        public void setFollowRedirectFilter(Boolean followRedirectFilter) {
            this.followRedirectFilter = followRedirectFilter;
        }

        public Map getParameters() {
            return this.parameters;
        }

        public void setParameters(Map parameters) {
            this.parameters = parameters;
        }

        public DockerOperation getOperation() {
            return this.operation;
        }

        public void setOperation(DockerOperation operation) {
            this.operation = operation;
        }

        public Boolean getTlsVerify() {
            return this.tlsVerify;
        }

        public void setTlsVerify(Boolean tlsVerify) {
            this.tlsVerify = tlsVerify;
        }

        public Boolean getSocket() {
            return this.socket;
        }

        public void setSocket(Boolean socket) {
            this.socket = socket;
        }

        public String getCmdExecFactory() {
            return this.cmdExecFactory;
        }

        public void setCmdExecFactory(String cmdExecFactory) {
            this.cmdExecFactory = cmdExecFactory;
        }
    }
}

